<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;



class Creancier extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'creanciers';


    /* Dates */
    public function getDates()
    {
            return array('date_naiss');
    }


     public function getDateNaissAttribute($value)
    {
        return (($this->attributes['datenaiss']!="0000-00-00")&&($this->attributes['datenaiss']!=null))?date('d/m/Y', strtotime($this->attributes['datenaiss'])):"";
    }

        /* Nom */
    public function getNomCompletAttribute()
    {
            return $this->nom." ".$this->prenom;
    }

    public function getNomCompletReduitAttribute()
    {
        $taillemax=20;
        $t_prenom=explode(' ',$this->prenom);

        $prenom=trim($t_prenom[0]);
        if(strlen($prenom)>$taillemax) $prenom=substr($prenom,0,$taillemax);
        return trim($this->nom)." ".$prenom;
    }
    
        /* Nom */
    public function getBanqueAttribute()
    {
        $banque=Banque::find($this->bqcle_creancier);
        
        if(!$banque) return "";
        return $banque->nom;
    }

    /* Nom */
    public function getMontantEuroAttribute()
    {
            return round($this->montant*0.00838,2);
    }


    /* SUPPRESSION */
    function getIsSupprimableAttribute() {
        $mandat=Mandat::find($this->idmandat);
        if(!$mandat) return true;
        if($mandat->statut_mdt=="ENC") return true;
        return false;
    }

    /* Modifiable */
    function getIsModifiableAttribute() {
        $mandat=Mandat::find($this->idmandat);
        if(!$mandat) return true;
        if($mandat->statut_mdt=="ENC") return true;
        return false;
    }

}
