<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Employeur extends Model {
    
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'employeurs';


    /* Dates */
    public function getDates()
    {
            return array('date_deb','date_fin','der_mois','date_cont','date_med','date_maj','date_contr');
    }


     public function getDateDebAttribute($value)
    {
        return (($this->attributes['date_deb']!="0000-00-00")&&($this->attributes['date_deb']!=null))?date('d/m/Y', strtotime($this->attributes['date_deb'])):"";
    }

     public function getDatefinAttribute($value)
    {
        return (($this->attributes['date_fin']!="0000-00-00")&&($this->attributes['date_fin']!=null))?date('d/m/Y', strtotime($this->attributes['date_fin'])):"";
    }
     public function getDerMoisAttribute($value)
    {
        return (($this->attributes['der_mois']!="0000-00-00")&&($this->attributes['der_mois']!=null))?date('d/m/Y', strtotime($this->attributes['der_mois'])):"";
    }

     public function getDateContAttribute($value)
    {
        return (($this->attributes['date_cont']!="0000-00-00")&&($this->attributes['date_cont']!=null))?date('d/m/Y', strtotime($this->attributes['date_cont'])):"";
    }
      public function getDateMedAttribute($value)
    {
        return (($this->attributes['date_med']!="0000-00-00")&&($this->attributes['date_med']!=null))?date('d/m/Y', strtotime($this->attributes['date_med'])):"";
    }
      public function getDateMajAttribute($value)
    {
        return (($this->attributes['date_maj']!="0000-00-00")&&($this->attributes['date_maj']!=null))?date('d/m/Y', strtotime($this->attributes['date_maj'])):"";
    }
      public function getDateContrAttribute($value)
    {
        return (($this->attributes['date_contr']!="0000-00-00")&&($this->attributes['date_contr']!=null))?date('d/m/Y', strtotime($this->attributes['date_contr'])):"";
    }



    public function getIleLibelleAttribute($value)
    {
        $iles=[''=>'AUTRE'
            ,'W' => 'Wallis'
          , 'F' => 'Futuna'
          , 'N' => 'Nouvelle-Calédonie'
          , 'P' => 'Polynésie'
        ];
        $res=isset($iles[$this->ile])?$iles[$this->ile]:"";

        return $res;
    }

    public function getNomIleAttribute($value)
    {
        $iles=[''=>''
            ,'W' => 'Wallis'
          , 'F' => 'Futuna'
          , 'N' => 'Nouvelle-Calédonie'
          , 'P' => 'Polynésie'
        ];
        $res=isset($iles[$this->ile])?$iles[$this->ile]:"";

        return $res;
    }


    public function getAdresseCompleteAttribute()
    {
        $sep="<br/>";
        $adresse=trim($this->adresse);
        if($this->cp) $adresse.=$sep.$this->cp;
        if($this->district) $adresse.=$sep.$this->district;
        if($this->ile) $adresse.=$sep.$this->NomIle;

        return $this->adresse;
    }

    public function getNomBanqueAttribute($ref)
    {
        $banque=Banque::find($this->banque_id);
        if(!$banque) return "";
        return $banque->nom;
    }

    public function getSecteurAttribute($ref)
    {
        $secteur=Secteur::find($this->sec_id);
        if(!$secteur) return "";
        return $secteur->nom;
    }


    public function getSendEmail($ref)
    {
        $emails=Email::where("sonum","=","$this->id")
          ->where("reference","=",$ref)
          ->orwhere("destinataire","=",$this->email)
          ->orderby('id','DESC')->get();
        return $emails;
    }

    public function getSendEmailLast($ref)
    {
        $email=Email::where("sonum","=",$this->id)
          ->where("reference","=",$ref)
          ->orwhere("destinataire","=",$this->email)
          ->orderby('id','DESC')->first();

        return $email;
    }

    public function getSendEmailLastDate($ref)
    {
      $date="";
        $email=$this->getSendEmailLast($ref);
        if($email) $date=$email->date;
        else $date="";
        return $date;
    }

    public function getSendEmailLastPJ($ref)
    {
        $pj="";
        $email=$this->getSendEmailLast($ref);
        if($email) $pj=$email->pj;
        else $pj="";
        return $pj;
    }


    //Envoi email Rappel dernier Trimestre O/N
    public function getEmailTrim($ref)
    {
        $trim="";
        $annee=date('Y');
        $t_annee[]=$annee;
        $mois_encours=intVal(date('m'));
        if($mois_encours<=3) $t_annee[]=$annee-1; //Année précédente aussi si on est en janvier février ou mars

        $email=Email::where("sonum","=",$this->id)
          ->where("reference","=",$ref)
          ->whereIn(db::raw("YEAR(date)"),$t_annee)
          ->orderby('id','DESC')->first();

        if(!$email) return "";
        $mois_email=date('m', strtotime($email->date));
        $annee_email=date('Y', strtotime($email->date));
        if( ($mois_email>=1)&& ($mois_email<=3)) $trim="T1"."-".$annee_email;
        if( ($mois_email>=4)&& ($mois_email<=6)) $trim="T2"."-".$annee_email;
        if( ($mois_email>=7)&& ($mois_email<=9)) $trim="T3"."-".$annee_email;
        if( ($mois_email>=10)&& ($mois_email<=12)) $trim="T4"."-".$annee_email;

        return $trim;
    }




    /**
     * Nombre d'enployés
     * @return int
     */
    public function getNbEmployesAttribute()
    {
        $nb=DB::table('beneficiaires')
          ->join('salaire','salaire.benum','=',"beneficiaires.id")
          ->where('salaire.annee','like',( (date('m')=="01") ? (date('Y')-1) : date('Y') ) )
          ->where('salaire.sonum','=',$this->id)
          ->where('beneficiaires.sonum', '=', $this->id)->count();

        return $nb;
    }


    public function getNbEmployes($annee)
    {
        $nb=DB::table('salaire')
          ->where('salaire.annee','=',$annee )
          ->where('salaire.annee','like',( (date('m')=="01") ? ($annee-1) : $annee ) )
          ->where('salaire.sonum','=',$this->id)
          ->count();
        /*
        $nb=DB::table('beneficiaires')
          ->join('salaire','salaire.benum','=',"beneficiaires.id")
          ->where('salaire.annee','like',( (date('m')=="01") ? ($annee-1) : $annee ) )
          ->where('salaire.sonum','=',$this->id)
          ->where('beneficiaires.sonum', '=', $this->id)
          ->count();*/

        return $nb;
    }


    public function getNbEmployesMois($date="")
    {
        if($date=="") $date=date('Y-m-d');
        $t_mois=[1=>"jan",2=>"fev",3=>"mar",4=>"avr",5=>"mai",
          6=>"jun",7=>"jui",8=>"aou",9=>"sep",10=>"oct",11=>"nov",12=>"dec"];
        $annee=substr($date,0,4);
        $mois=substr($date,5,2);

        $lib_mois=$t_mois[intval($mois)];
        
        $nb=DB::table('salaire')
          ->where('salaire.annee','=',$annee )
          ->where('salaire.'.$lib_mois,'>',0)
          ->where('salaire.sonum','=',$this->id)
          ->count();

//if(($this->id==67))  dd($mois);


        return $nb;
    }


    public function getMasseSalarialeMois($date="")
    {
        if($date=="") $date=date('Y-m-d');
        $t_mois=[1=>"jan",2=>"fev",3=>"mar",4=>"avr",5=>"mai",
          6=>"jun",7=>"jui",8=>"aou",9=>"sep",10=>"oct",11=>"nov",12=>"dec"];
        $annee=substr($date,0,4);
        $mois=substr($date,5,2);
        $lib_mois=$t_mois[intval($mois)];
        $masse=DB::table('salaire')
          ->where('salaire.annee','=',$annee )
          ->where('salaire.sonum','=',$this->id)
          ->sum('salaire.'.$lib_mois);
        return $masse;
    }

    /**
     * Nombre de salaires
     * @return int
     */
    public function getNbSalairesAttribute()
    {
        $nb=DB::table('salaire')->where('benum', '=', $this->id)->count();
        return $nb;
    }


    /**
     * Nombre de controles
     * @return int
     */
    public function getNbControleAttribute()
    {
        $nb=DB::table('controle')->where('sonum', '=', $this->id)->count();
        return $nb;
    }

    /**
     * Nombre de cotisations
     * @return int
     */
    public function getNbCotisationsAttribute()
    {
        $nb=DB::table('cotis')->where('sonum', '=', $this->id)->count();
        return $nb;
    }

    /**
     * Nombre de cotisations g
     * @return int
     */
    public function getNbCotisationsGAttribute()
    {
        $nb=DB::table('cotis_g')->where('sonum', '=', $this->id)->count();
        return $nb;
    }

    /**
     * Nombre de cotisations
     * @return int
     */
    public function getNbSuivisAttribute()
    {
        $nb=DB::table('suivi_soc')->where('so_num', '=', $this->id)->count();
        return $nb;
    }


    /**
     * Nombre de versements
     * @return int
     */
    public function getNomReduitAttribute()
    {
        $nom=str_replace('"','',$this->nom);
        return $nom;
    }


    public function getNomCourtAttribute()
    {
        $max=25;
        if(strlen($this->nom)>$max) return substr($this->nom,0,$max);
        return $this->nom;
    }

    public function getNomCourtVar($max)
    {
        if(strlen($this->nom)>$max) return substr($this->nom,0,$max);
        return $this->nom;
    }

    /**
     * Nombre de versements
     * @return int
     */
    public function getNbVersemAttribute()
    {
        $nb=DB::table('versem')->where('sonum', '=', $this->id)->count();
        return $nb;
    }

    /**
     * Si aucun lien cascade => true
     * @return boolean
     */
    public function getHasCascadeAttribute()
    {
        if($this->nb_employes>0) return false;
        if($this->nb_salaires>0) return false;
        if($this->nb_controle>0) return false;
        if($this->nb_cotisations>0) return false;
        if($this->nb_cotisations_g>0) return false;
        if($this->nb_suivis>0) return false;
        return true;
    }



    //PAR TRIMESTRE
    public function getTableauTrim()
    {
        $t_trim=[
          "1D"=>"01-01","1F"=>"04-31",
          "2D"=>"04-01","2F"=>"06-30",
          "3D"=>"07-01","3F"=>"09-31",
          "4D"=>"10-01","4F"=>"12-31"
          ];
          return $t_trim;
    }  

    public function getDebitCreditTrim($trim,$annee,$type="debit")
    { 

      $trim=$trim-1;
      if($trim==0) {$trim=4;$annee=$annee-1;}

      $t_trim=$this->getTableauTrim();
      $deb=$annee."-".$t_trim[$trim."D"];
      $fin=$annee."-".$t_trim[$trim."F"];
      $credit=DB::table('cotis')
            ->where('sonum', '=', $this->id)
            ->whereBetween('mois', array( $deb, $fin))
            ->sum($type);

      if(!isset($credit)) $credit=0;
      return $credit;
    }

    public function getDebitTrim($trim,$annee,$debit="D")
    { 
      return $this->getDebitCreditTrim($trim,$annee,"credit");
    }
    public function getCreditTrim($trim,$annee)
    { 
      return $this->getDebitCreditTrim($trim,$annee,"debit");
    }

    
    public function getCreditAttribute()
    {
        $credit=DB::table('cotis')
            ->where('sonum', '=', $this->id)->sum('credit');
        return $credit;
    }

    public function getDebitAttribute()
    {
        $debit=DB::table('cotis')
            ->where('sonum', '=', $this->id)->sum('debit');
        return $debit;
    }



    /* SUR 2 ANS */
    public function getCredit2Year($annee)
    {
      $credit=DB::table('cotis')
            ->where('exercice', '<=', $annee)
            ->where('sonum', '=', $this->id)
            ->sum('credit');

      return ($credit);
    }

    public function getDebit2Year($annee)
    {
      $debit=DB::table('cotis')
            ->where('exercice', '<=', $annee)
            ->where('sonum', '=', $this->id)
            ->sum('debit');

      return ($debit);
    }

      public function getSolde2Year($annee)
    {
      $credit=$this->getCredit2Year($annee);
      $debit=$this->getDebit2Year($annee);

       return ($credit-$debit);
    }
    /* FIN SUR  2 ANS */


    /* ******** */
    /* Cotisations */
    /* ******** */

    public function getCotisations($type,$annee="",$date_limite="")
    {
      $cotisations_obj=DB::table('cotis')->where('sonum', '=', $this->id);

      if($annee!=""){
        //$cotisations_obj=$cotisations_obj->where('exercice', '=', $annee);
        if($type=="E") $cotisations_obj=$cotisations_obj->where(DB::raw('YEAR(mois)'),'=', $annee);
        if($type=="C") $cotisations_obj=$cotisations_obj->where(DB::raw('YEAR(mois)'),'<=', $annee);
      }

      if($date_limite!="") {
        $cotisations_obj=$cotisations_obj->where('date', '<=', $date_limite);
      }

      $cotisations=$cotisations_obj->orderby('mois','ASC')->get();
      return $cotisations;
    }


    /* ******************************************************** */
    /* Crédit Debit Cotisation cumulées jusqu'a une date donnée */
    /* ******************************************************** */
    public function getCreditDebit($annee,$date_limite="",$type)
    {
      $valsum=0;
      $valsum_obj=DB::table('cotis')
            ->where('sonum', '=', $this->id)
            ->where(DB::raw('YEAR(mois)'),'<=', $annee);
      if($date_limite!="") $valsum_obj=$valsum_obj->where('date','<=', $date_limite);
      if($type=="C") $valsum=$valsum_obj->sum('credit');
      if($type=="D") $valsum=$valsum_obj->sum('debit');

      return $valsum;
    }
    public function getCredit($annee,$date_limite="")
    {
      return $this->getCreditDebit($annee,$date_limite,"C");
    }
    public function getDebit($annee,$date_limite="")
    {
      return $this->getCreditDebit($annee,$date_limite,"D");
    }
    public function getSolde($annee,$date_limite="")
    {
      $credit=$this->getCredit($annee,$date_limite);
      $debit=$this->getDebit($annee,$date_limite);

      return ($credit-$debit);
    }
    /* ******************************************************** */
    /* FIN de Cumule Jusqu'a .. Date */
    /* ******************************************************** */

    /* ******************************************************** */
    /* Crédit Debit Cotisation Exercice jusqu'a une date donnée */
    /* ******************************************************** */
    public function getCreditDebitExercice($annee,$date_limite="",$type)
    {
      $valsum=0;
      /*
      $valsum_obj=DB::table('cotis')
            ->where('sonum', '=', $this->id)
            ->where(DB::raw('YEAR(date)'),'=', $annee);

      if($date_limite!="") $valsum_obj=$valsum_obj->where('date','<=', $date_limite);
        */
      $valsum_obj=DB::table('cotis')
            ->where('sonum', '=', $this->id)
            ->where('exercice','=', $annee);


      if($date_limite!="") $valsum_obj=$valsum_obj->where('exercice','<=', substr($date_limite,0,4));

      if($type=="C") $valsum=$valsum_obj->sum('credit');
      if($type=="D") $valsum=$valsum_obj->sum('debit');

      return $valsum;
    }
    public function getCreditExercice($annee,$date_limite="")
    {
      return $this->getCreditDebitExercice($annee,$date_limite,"C");
    }
    /* CREDITS et DEBITS toute date */
    public function getDebitExercice($annee,$date_limite="")
    {
      return $this->getCreditDebitExercice($annee,$date_limite,"D");
    }
    public function getSoldeExercice($annee,$date_limite="")
    {
      $credit=$this->getCreditExercice($annee,$date_limite);
      $debit=$this->getDebitExercice($annee,$date_limite);

      return ($credit-$debit);
    }
    /* ******************************************************** */
    /* FIN de Exercice jusqu'a .. Date */
    /* ******************************************************** */



    public function getCreditDateAttribute($date)
    {

        $credit=DB::table('cotis')
            ->where('sonum', '=', $this->id)
            ->whereBetween('mois', array( $deb, $fin))
            ->sum('credit');
        return $credit;
    }

    public function getResteAPayerAttribute()
    {
        $reste=$this->debit - $this->credit;
        return $reste;
    }


    public function getResteAPayerExercice($annee,$date="")
    {
        $reste=$this->getSoldeExercice($annee,$date);
        return $reste;
    }
    

    //Reste à payer sur une année ou / et date de rattachement
    public function getResteAPayerCumule($annee,$date="")
    {
        $reste=$this->getSolde($annee,$date);
        return $reste;
    }


    /* ******** */
    /* SALAIRES */
    /* ******** */
    public function getSalairesActifs()
    {
        $annee=date('Y');
        //Rechecrhe les bene du dernier salaire
        $salaires=Salaire::select('benum')->where('salaire.sonum','=',$this->id)
            ->where('annee','=',$annee)->get();

        $nb_total=count($salaires);
        if($nb_total==0) {
            $annee=$annee-1;
            $salaires=Salaire::select('benum')
                ->distinct()
                ->where('salaire.sonum','=',$this->id)
                ->where('annee','=',$annee)->get();


        }

        $lst_employes=array();
        foreach($salaires as $salaire) $lst_employes[]=$salaire->benum;
        
        $salaires=Salaire::join('beneficiaires','beneficiaires.id','=','salaire.benum')
            ->whereIn('beneficiaires.id',$lst_employes)
            ->where('salaire.annee','=',$annee)
            ->where('salaire.sonum','=',$this->id)
            ->orderby('beneficiaires.nom')
            ->orderby('beneficiaires.prenom')
            ->get();


        return $salaires;
    }

    public function getMasseSalairesActifs($annee)
    {
      $total=0;
      $salaires=Salaire::join('beneficiaires','beneficiaires.id','=','salaire.benum')
          ->where('salaire.sonum','=',$this->id)
          ->where('salaire.annee','=',$annee)
          ->get();

      foreach($salaires as $salaire) {
        $total+=$salaire->TotalAnnee;
      }
      return $total;
    }

    public function getDernierSalaireSaisiAttribute($annee)
    {

      //Recherce année du dernier salaire saisi
      $salaires_last=Salaire::where('sonum','=',$this->id)
        ->where('date_sor','=','0000-00-00')
        //->where('annee','=',$annee)
        ->orderby('salaire.annee','DESC')
        ->get();

      //if(!$salaires_last) return "";
      $mois=0;$maxmois=0;
      foreach($salaires_last as $salaire) {
          $max_mois=$salaire->annee.$salaire->LastMoisSalaire;
          if($max_mois>$mois) {
            $salaire_last=$salaire;
            $mois=$max_mois;
          }
      }
      if(isset($salaire_last)) return $salaire_last;
      return "";


      /*
      //Recherce année du dernier salaire saisi
      $salaire_last=Salaire::where('sonum','=',$this->id)
        ->where('date_sor','=','0000-00-00')
        ->orderby('salaire.annee','DESC')

        ->first();

      if(isset($salaire_last)) return $salaire_last;
      return "";
      */
      
    }

    public function getDateDernierSalaireAttribute()
    {
      $total=0;
      $dernier_moi="";
      $t_mois=[1=>"jan",2=>"fev",3=>"mar",4=>"avr",5=>"mai",
          6=>"jun",7=>"jui",8=>"aou",9=>"sep",10=>"oct",11=>"nov",12=>"dec"];

      $salaire_last=$this->DernierSalaireSaisi;
      if($salaire_last=="") return "";


      $annee_last=$salaire_last->annee;
      $mois_last=$salaire_last->LastMoisSalaire;
      //$dernier_mois=$t_mois[intval($salaire_last->LastMoisSalaire)];


      
      return $annee_last."-".$mois_last;
    }

    public function getMasseDerniersSalaires($annee)
    {
      $total=0;
      $dernier_moi="";
      $t_mois=[1=>"jan",2=>"fev",3=>"mar",4=>"avr",5=>"mai",
          6=>"jun",7=>"jui",8=>"aou",9=>"sep",10=>"oct",11=>"nov",12=>"dec"];

      $salaire_last=$this->DernierSalaireSaisi;
      if($salaire_last=="") return "";


      //Calcul la masse des derniers salaires
      if($salaire_last->LastMoisSalaire!="") {
        $dernier_mois=$t_mois[intval($salaire_last->LastMoisSalaire)];
        $salaires=Salaire::join('beneficiaires','beneficiaires.id','=','salaire.benum')
            ->where('salaire.sonum','=',$this->id)
            ->where('salaire.annee','=',$salaire_last->annee)
            ->get();


        foreach($salaires as $salaire) {
          $montant_last_mois=$salaire->{$dernier_mois};
          $total+=$montant_last_mois;
        }
      }
      
      return $total;
    }

    public function getMajoration($annee)
    {
      $salaire_last=$this->DernierSalaireSaisi;
      if($salaire_last=="") return 0; 

      $prc_maj=Parametre::where('ref','=','CAL_PRC_MAJ')->first()->value;
      $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
      $taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();
      $taux=$taux_CLR[$annee]+$taux_CPF[$annee];
      $masse_dernier=$this->getMasseDerniersSalaires($annee);
      $mois_manquants=$this->getNbMoisManquantsSalaires($annee);
      $taux_total=$taux;
      $cotisations=round($masse_dernier*$taux_total/100,0);
      $majorations=0;
      $k=0;
      $majorations_total=0;
      $nbtri=0;
      $majorations_base=round($cotisations*$prc_maj/100,2)*3;
      for($i=1;$i<=($mois_manquants-3);$i++) {
        $k++;
        if($k==3) {
          $nbtri++;
          $majorations_total+=$nbtri*($majorations_base*3);
          //if($this->id=='1537') echo $majorations_total."<br>";
          $k=0;
        }   
      }
      return round($majorations_total);
    }

    public function getNbMoisManquantsSalaires($annee)
    {
      $salaire_last=$this->DernierSalaireSaisi;
      
      if($salaire_last=="") return "";
      if($salaire_last->LastMoisSalaire!="") {
        $nb_mois_manquants=12-$salaire_last->LastMoisSalaire;
        $nb_annees=($annee-($salaire_last->annee));
        if($nb_annees>0) {
          $nb_mois_manquants=$nb_mois_manquants+($nb_annees*12);
        } else $nb_mois_manquants=0;

        if($nb_mois_manquants>12) return 12;
        return $nb_mois_manquants;
      }
    }

    public function getMasseManquanteSalaires($annee)
    {
      $salaire_last=$this->DernierSalaireSaisi;
      if($salaire_last=="") return 0;
      if($salaire_last->LastMoisSalaire!="") {
        $nb_mois_manquants=$this->getNbMoisManquantsSalaires($annee);
        $masse_manquante=$this->getMasseDerniersSalaires($annee)*$nb_mois_manquants;
        return $masse_manquante;
      }
      return 0;
    }

    public function getMasseSalairesAnnee($annee="")
    {
        if($annee=="") $annee=date('Y');
        //Rechecrhe les bene du dernier salaire
        $salaires=Salaire::select('benum')->where('salaire.sonum','=',$this->id)
            ->where('annee','=',$annee)->get();

        $nb_total=count($salaires);
        if($nb_total==0) {
            $annee=$annee-1;
            $salaires=Salaire::select('benum')
                ->distinct()
                ->where('salaire.sonum','=',$this->id)
                ->where('annee','=',$annee)->get();
        }
        $lst_employes=array();
        foreach($salaires as $salaire) $lst_employes[]=$salaire->benum;
        

        $salaires=Salaire::join('beneficiaires','beneficiaires.id','=','salaire.benum')
            ->whereIn('beneficiaires.id',$lst_employes)
            ->where('salaire.annee','=',$annee)
            ->get();

        $t_mois=[1=>0,2=>0,3=>0,4=>0,5=>0,6=>0,7=>0,8=>0,9=>0,10=>0,11=>0,12=>0];
        $masse=0;
        foreach($salaires as $salaire) {
          if($salaire->jan>0) $t_mois[1]+=1;
          if($salaire->fev>0) $t_mois[2]+=1;
          if($salaire->mar>0) $t_mois[3]+=1;
          if($salaire->avr>0) $t_mois[4]+=1;
          if($salaire->mai>0) $t_mois[5]+=1;
          if($salaire->jun>0) $t_mois[6]+=1;
          if($salaire->jui>0) $t_mois[7]+=1;
          if($salaire->aou>0) $t_mois[8]+=1;
          if($salaire->sep>0) $t_mois[9]+=1;
          if($salaire->oct>0) $t_mois[10]+=1;
          if($salaire->nov>0) $t_mois[11]+=1;
          if($salaire->dec>0) $t_mois[12]+=1;
          $masse+=$salaire->TotalAnnee;
        }
        $t_mois[0]=$masse;

        return $t_mois;
    }

    /* FIN SALAIRES */


    /* MISES EN DEMEURE */
    public function getListeMedHTMLAttribute()
    {
      $liste="";
      $meds=Med::where('sonum','=',$this->id)->get();

      foreach($meds as $med) {
        $txt=$med->date_envoi.'&nbsp;N°'.str_pad($med->numero,4,"0",STR_PAD_LEFT);
        $link="<a class='various fancybox.iframe' href='".url('med/'.$med->id)."'>".$txt."</a>";
        $liste.=(($liste=="")?"":"<br>").$link;
      }
      return $liste;
    }
    /* ************* */


    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }


    /* ******************************************************** */
    /* COMPTABILITE */
    /* ******************************************************** */


    //Ecritures
    public function getEcritures($exercice="") {
        if(!$this->compte_aux) return "";
        if(!$exercice) $exercice=date('Y');
        $ecritures=GrandLivre::where('compte_aux','=',$this->compte_aux)->where(DB::raw('YEAR(date_doc)'),'=', $exercice)->get();

        return $ecritures;
    }

    //Solde
    public function getSoldeCompta($exercice="") {
        $ecritures=$this->getEcritures($exercice);
        if(!$ecritures) return "";
        $solde=0;

        foreach ($ecritures as $ecriture) {
            $solde+=$ecriture->credit-$ecriture->debit;
        }
        return $solde;
    }



}
