<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Imputation extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'imputation_mdt';


    /* Statut Mandat */
    function getMandatStatutAttribute() {
        $mandat=Mandat::find($this->idmandat);
        if(!$mandat) return "";
        return $mandat->statut_mdt;
    }


    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value;
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }


    /* SUPPRESSION */
    function getIsSupprimableAttribute() {
        $mandat=Mandat::find($this->idmandat);
        if(!$mandat) return true;
        if($mandat->statut_mdt=="ENC") return true;
        return false;
    }

    function getDateTransfertAttribute() {
        $mandat=Mandat::find($this->idmandat);
        if(!$mandat) return true;
        return $mandat->date_transfert;
    }


    /* Modifiable */
    function getIsModifiableAttribute() {
        $mandat=Mandat::find($this->idmandat);
        if(!$mandat) return true;
        if($mandat->statut_mdt=="ENC") return true;
        return false;
    }

    /* Date Mandat */
    function getMandatDateAttribute() {

        $mandat=Mandat::find($this->idmandat);
        if(!$mandat) return "";

        return $mandat->date_sai;
    }

    /* Type Mandat */
    function getMandatTypeAttribute() {
        $mandat=Mandat::find($this->idmandat);
        if(!$mandat) return "";
        return $mandat->type;
    }
}
