<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Mandat extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'mandats';


    /* Dates */
    public function getDates()
    {
            return array('date_sai','date_valid','date_valid_dir,date_transfert');
    }


     public function getDateSaiAttribute($value)
    {
        return (($this->attributes['date_sai']!="0000-00-00")&&($this->attributes['date_sai']!=null))?date('d/m/Y', strtotime($this->attributes['date_sai'])):"";
    }
     public function getDateValidAttribute($value)
    {
        return (($this->attributes['date_valid']!="0000-00-00")&&($this->attributes['date_valid']!=null))?date('d/m/Y', strtotime($this->attributes['date_valid'])):"";
    }
     public function getDateValidDirAttribute($value)
    {
        return (($this->attributes['date_valid_dir']!="0000-00-00")&&($this->attributes['date_valid_dir']!=null))?date('d/m/Y', strtotime($this->attributes['date_valid_dir'])):"";
    }
     public function getDateTransfertAttribute($value)
    {
        return (($this->attributes['date_transfert']!="0000-00-00")&&($this->attributes['date_transfert']!=null))?date('d/m/Y', strtotime($this->attributes['date_transfert'])):"";
    }


     public function getDateSaiUSAttribute($value)
    {
        return $this->attributes['date_sai'];
    }

     public function getDateValidUSAttribute($value)
    {
        return $this->attributes['date_valid'];
    }

     public function getDateValidDirUSAttribute($value)
    {
        return $this->attributes['date_valid_dir'];
    }
    
     public function getMontantAttribute()
    {

        $montant=DB::table('creanciers')->select(db::raw("SUM(montant) as montant"))
            ->where('idmandat','=',$this->id)->value('montant');
        if(!isset($montant) || $montant=="") $montant=0;
        $montant=number_format($montant,0,","," ");
        return $montant;
    }

     public function getStatutTransfertLibelleAttribute()
    {
        if($this->statut_transfert=="ATR") return "En attente";
        if($this->statut_transfert=="TRA") return "Créé";
        return "";
    }

     public function getListeCreancierHTML()
    {

        //$creanciers=DB::table('creanciers')
        //    ->select(db::raw("CONCAT(nom,' ',prenom) as nom"),'montant')->where('idmandat','=',$this->id)
        //    ->get();
        $creanciers=Creancier::where('idmandat','=',$this->id)->get();
        $lst="";
        foreach($creanciers as $creancier) {
            $lst.=(($lst=="")?"":"<br/>").$creancier->NomCompletReduit.
                " - ".
                "<span style='white-space:nowrap;font-weight:bold;color:darkred;'>".
                number_format($creancier->montant,0,","," ")." CFP".
                "</span>";
        }
        return $lst;
    }

     public function getListeCreancierHTML_Export()
    {

        $creanciers=Creancier::where('idmandat','=',$this->id)->get();

        $style_col1="style='padding:3px;font-size:0.8em;font-weight:normal;color:darkblue;'";
        $style_col2="style='padding:3px;font-size:0.8em;font-weight:bold;color:darkred;'";
        $style_col3="style='padding:3px;font-size:0.8em;font-weight:normal;color:black;'";
        $style_erreur="style='padding:3px;font-size:0.8em;font-weight:bold;color:red;'";

        $lst="<table border=0 cellspacing='15' width='85%' style='background-color:white'>";
        $lst.="<tr>";
        $lst.=" <th width='10%'></th>";
        $lst.=" <th width='30%'></th>";
        $lst.=" <th width='40%'></th>";
        $lst.=" <th width='10%'></th>";
        $lst.=" <th width='10%'></th>";
        $lst.="</tr>";
        foreach($creanciers as $creancier) {
            $banque=Banque::find($creancier->bqcle_creancier);
            $lst.="<tr>";
            $lst.=" <td ".$style_col1.">".$this->id."</td>";
            $lst.=" <td ".$style_col1.">".$creancier->NomCompletReduit."</td>";
            $lst.=" <td align='right' ".$style_col3.">".$banque->nom." - ".$creancier->compte."</td>";
            $lst.=" <td nowrap align='right' ".$style_col2.">".number_format($creancier->montant,0,","," ")."&nbsp;CFP"."</td>";
            if(strlen($creancier->compte)<21) {
                $lst.=" <td ".$style_erreur." nowrap >COMPTE INCORRECT</td>";
            } else {
                $lst.=" <td>&nbsp;</td>";
            }
            $lst.="</tr>";
        }
        $lst.="</table>";
        return $lst;
    }

     public function getNbCompteIncorrectAttribute()
    {
        $nb=0;
        $creanciers=Creancier::where('idmandat','=',$this->id)->get();
        foreach($creanciers as $creancier) {
            $banque=Banque::find($creancier->bqcle_creancier);
            if(strlen($creancier->compte)<21) $nb++;
        }
        return $nb;
    }

     public function getListeImputationsHTML()
    {

        $imputations=DB::table('imputation_mdt')
            ->select('cpt_imp','montant','type_imp','designation')
            ->where('idmandat','=',$this->id)->get();
        $lst="";
        foreach($imputations as $imputation) {
            $lst.=(($lst=="")?"":"<br/>").$imputation->cpt_imp.
                ' '.$imputation->type_imp.
                " - ".
                "<span style='font-weight:bold;color:darkred;'>".
                number_format($imputation->montant,0,","," ")." CFP".
                "</span>".
                '<br>'.$imputation->designation;
        }
        return $lst;
    }

    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }
}
