<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class MyApp extends Model {


    const JOURS=["LUNDI","MARDI","MERCREDI","JEUDI","VENDREDI","SAMEDI"];
    const DAY_TO_NUM=["Mon"=>0,"Tue"=>1,"Wed"=>2,"Thu"=>3,"Fri"=>4,"Sat"=>5,"Sun"=>4];
    const MOIS=["JANVIER","FEVRIER","MARS","AVRIL","MAI","JUIN","JUILLET","AOUT","SEPTEMBRE","OCTOBRE","NOVEMBRE","DECEMBRE"];
    const MOIS_COURT_LONG=['jan'=>'Janvier','fev'=>'Février','mar'=>'Mars','avr'=>'Avril','mai'=>'Mai','jun'=>'Juin','jui'=>'Juillet','aou'=>'Août','sep'=>'Septembre','oct'=>'Octobre','nov'=>'Novembre','dec'=>'Décembre'];
    const MOIS_US_FR=['Jan'=>'Jan','Feb'=>'Fev','Mar'=>'Mar','Apr'=>'Avr','May'=>'Mai','Jun'=>'Jun','Jul'=>'Jul','Aug'=>'Aoû','Sep'=>'Sep','Oct'=>'Oct','Nov'=>'Nov','Dec'=>'Déc'];   

    const STATUTS_ENTREPRISE=['ACT' => 'Activité','TER' => 'Terminé','ASV' => 'ASV','AR2' => 'AR2','AR3' => 'AR3','AR4' => 'AR4','MES'=>'MISE EN SOMMEIL','CTE'=>'CONTENTIEUX',''=>'Non défini',];

    const COTIS_TYPE_OPE=[
        'DNT'=>'DNT - Cotisation ou déclaration nominative trimestrielle',
        'DNM' => 'DNM - Cotisation ou déclaration nominative mensuelle',
        'TAF' => 'TAF - Taxation forfaitaire',
        'TAO' => 'TAO - Taxation d’office',
        'AST' => 'AST - Astreinte',
        'MAJ' => 'MAJ - Majorations',
        'ANN' => 'ANN - Annulation',
        'REG' => 'REG - Règlement (crédit)'
    ];

    const COTIS_TYPE=['ENC'=>'Encaissement','RAP' => 'Rappel','PEC' => 'Paiement échelonné',
            'CST' => 'Constats','CAD' => "Cessation d'activité définitive",'CAT' => "Cessation d'activité temporaire"];

    const DISTRICTS2=['AUT'=>'AUTRE','HAHAKE' => 'HAHAKE', 'HIHIFO' => 'HIHIFO', 'MUA' => 'MUA', 'SIGAVE' => 'SIGAVE', 'ALO' => 'ALO', 'NOUVELLE-CALEDONIE' => 'NOUVELLE-CALEDONIE', 'TAHITI' => 'TAHITI'];
    const ILES=['W' => 'Wallis', 'F' => 'Futuna', 'A' => 'Autres'];
    const ILES2=['A'=>'AUTRE','W' => 'Wallis', 'F' => 'Futuna', 'N' => 'Nouvelle-Calédonie', 'P' => 'Polynésie', 'R' => 'France'];
    const COLOR=['debit'=>'','credit'=>'','solde'=>''];
    const TYPE_PIECES=["AC"=>"Appel à cotisation","RG"=>"Règlements de cotisations","MD"=>"Mandats"];
    //https://mycolor.space/?hex=%23845EC2&sub=1
    const color_menus=["allocations"=>"#2c73d2","aides_sociales"=>"#008f7a","retraites"=>"#008e9b","recouvrement"=>"#845ec2","mandatement"=>"#b39cd0","comptabilite"=>"#ff9671","analyses"=>"#ffc75f","parametres"=>"#d5cabd","acces"=>"#d65db1"];
    
    const COMPTES_ENCAISSEMENT=[
        'W' => 'Wallis',
        'F' => 'Futuna',
        '512000' => '512 000 - Virement sur compte trésor',
        '512201' => '512 201 - Virement sur compte BWF',
        '513000' => '513 000 - Paiement en espèces sur Wallis',
        '513100' => '513 100 - Paiement en espèces sur Futuna',
        '511200' => '511 200 - Paiement par chèque',
        '511300' => '511 300 - Effets à l’encaissement en banque'
    ];

    const COMPTES_COTISANT_CLR="";
    const COMPTES_COTISANT_CPSWF="512201";


    const RAN_COMPTES_COTISANT_CLR="474001"; //COTISANTS CLR...
    const RAN_COMPTES_COTISANT_CPSWF="474000"; //COTISANTS CCPF...
    const RAN_COMPTES_CONTREP_CPSWF="756200"; //COTISATIONS PRIVE CCPF..
    const RAN_COMPTES_CONTREP_CLR="756201"; //COTISATIONS PRIVE CLR...



    /* ************************** */
    /*           COULeURS            */
    /* ************************** */
    static public function getColor($type)
    {
        $t_color=MyApp::COLOR;
        if(!isset($t_color[$type])) return "";
        return $t_color[$type];
    }


    /* ************************** */
    /*           COOKIE            */
    /* ************************** */

    /**
     * renvoi la valeur Session et enregistre
     */
    static public function getSessionValue($value,$name_variable)
    {
        $result=$value;
        if($result=="") {
            $result=Session::get($name_variable);
            if($result=="") {
                if($name_variable=='date_deb') $result=date('Y')."-01-01";
                if($name_variable=='date_fin') $result=date('Y')."-12-31";
            }
        }
        Session::put($name_variable,$result);

        return $result;
    }


    /* ************************** */
    /*           DATES            */
    /* ************************** */

    /**
     * Listes des exercices
     */
    static public function getListeExercices()
    {
        $exercice = Parametre::where('ref2','=','TAUX_CLR_CCPF')->first();

        $exercices=$exercice->Exercices;

        return $exercices;
    }

    static public function getMoisFr($mois_us)
    {
        setlocale(LC_TIME, "fr_FR", "French");
        $date_jour=(strftime("%B %Y", strtotime($mois_us."-01")));
        $date_jour=utf8_encode(ucfirst($date_jour));
        return $date_jour;
    }

    static public function isValidDate($date) {
        return date('Y-m-d', strtotime($date)) === $date;
    }

    static public function getDayWeek($today) {
        //Cours du jour
        if($today=="") $today=date('Y-m-d');
        $day = 1;
        $day_of_the_week = date('w', strtotime($today));
        $first_day_week = date('Y-m-d', strtotime(($day - $day_of_the_week). ' day', strtotime($today)));
        $last_day_week=date('Y-m-d', strtotime((5). ' day', strtotime($first_day_week)));

        return [$first_day_week,$last_day_week];
    }

    // retourne le dernier et premier jour d'un mois
    static public function getJoursMois($date) {
        //Cours du jour
        $t=array();
        $mois=date('m', strtotime($date));
        $first=date("Y-m-d", mktime(0, 0, 0, $mois,1 ,date("Y")));
        $last=date("Y-m-d", mktime(0, 0, 0, $mois+1,0 ,date("Y")));
        $t['premier']=$first;
        $t['dernier']=$last;

        return $t;
    }

    static public function getNbjDate($date1,$date2)
    {

        setlocale(LC_TIME, "fr_FR", "French");
        $date1 = strtotime($date1);
        $date2 = strtotime($date2);
        $diff = abs($date1 - $date2); // abs pour avoir la valeur absolute, ainsi éviter d'avoir une différence négative
        $retour = array();

        $tmp = $diff;
        $retour['second'] = $tmp % 60;

        $tmp = floor( ($tmp - $retour['second']) /60 );
        $retour['minute'] = $tmp % 60;

        $tmp = floor( ($tmp - $retour['minute'])/60 );
        $retour['hour'] = $tmp % 24;

        $tmp = floor( ($tmp - $retour['hour'])  /24 );
        $retour['day'] = $tmp;

        return $retour['day'];
    }

    // retourne le dernier et premier jour d'un mois
    static public function getMoisDate($date) {
        setlocale(LC_TIME, "fr_FR", "French");
        $mois=date('M', strtotime($date));
        if(isset(MyApp::MOIS_US_FR[$mois])) return MyApp::MOIS_US_FR[$mois];
        return $mois;
    }


    /* ************************** */
    /*           COMPTA            */
    /* ************************** */
    static public function getCompteAux($type) {
        $t="";
        if($type=="employeurs") {
            $t=DB::table('employeurs')
                ->select('compte_aux', db::raw('CONCAT(compte_aux," ",nom) as nom2'),'nom')
                ->orderby(db::raw("TRIM(nom)"))->pluck('nom2', 'compte_aux')->toArray();
        }
        return $t;
    }

    static function passgen1($nbChar) {
        $chaine ="mnoTUzS5678kVvwxy9WXYZRNCDEFrslq41GtuaHIJKpOPQA23LcdefghiBMbj0";
        srand((double)microtime()*1000000);
        $pass = '';
        for($i=0; $i<$nbChar; $i++){
            $pass .= $chaine[rand()%strlen($chaine)];
            }
        return $pass;
    }

    static function passgen2($nbChar){
        return substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCEFGHIJKLMNOPQRSTUVWXYZ0123456789'),1, $nbChar);
    }

    static function getCompteImputation($compte){
        $res="";
        if($compte=='CLR') $res=Parametre::where('ref','=','CPT_COMPTE_CLR')->first()->value;
        if($compte=='CPF') $res=Parametre::where('ref','=','CPT_COMPTE_CPF')->first()->value;
        if($compte=='ASE') $res=Parametre::where('ref','=','CPT_COMPTE_ASE')->first()->value;
        if($compte=='AVI') $res=Parametre::where('ref','=','CPT_COMPTE_AVI')->first()->value;
        if($compte=='CSR') $res=Parametre::where('ref','=','CPT_COMPTE_AVI')->first()->value;
        return $res;
    }

    /* ************************** */
    /*    SALAIRES /COTISATION    */
    /* ************************** */
    /**
     * plafond d'une date YYY-MM-JJ
     */
    static public function getPlafondCotisation($date)
    {
        $liste = Parametre::where('ref2','=','LST_PLAFOND_SMIG')->first();

        $val=$liste->value;
        //$val=str_replace('\r\n',"|",$liste->value);
        $t_values=explode("\r\n",$val);
        $plafond_prev="";
        $plafond="";
        foreach($t_values as $key=>$value) {
            if($value!="") {
                $t=explode(';',$value);
                $date_plafond=$t[0];
                $plafond=$t[3];

                if($plafond_prev=="") $plafond_prev=$plafond;
                if($date_plafond>$date) {
                    //dd($date_plafond.">".$date);
                    if($plafond_prev<>"") $plafond=$plafond_prev;
                }
                $plafond_prev=$plafond;
            }
        }

        return $plafond;
    }


    /* ************************** */
    /*    PARAMETRES              */
    /* ************************** */
    static public function getParam($ref)
    {
        $parametre=Parametre::where('ref','=',$ref)->first();
        if(!$parametre) return "";
        return $parametre->value;
    }

    static public function getTauxCLR($annee)
    {
        $t_taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        if(!isset($t_taux_CLR[$annee])) return "";
        return $t_taux_CLR[$annee];
    }

    static public function getTauxCPF($annee)
    {
        $t_taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();
        if(!isset($t_taux_CPF[$annee])) return "";
        return $t_taux_CPF[$annee];
    }



    /* ************************** */
    /*    INDICATEURS HOME        */
    /* ************************** */
    static public function getIndicateurs($role_type="")
    {
        $user = Auth::user();

        $t_indicateurs=[];

        if($role_type=="comptabilite") {
            $t_indicateurs["nb_cotisants"]=Indicateurs::getNbCotisants();
            $t_indicateurs["nb_employes"]=Indicateurs::getNbEmployes(date('Y'));
            $t_indicateurs["nb_ecritures"]=Indicateurs::getEcritures(date('Y'));
            $t_indicateurs["nb_transferts"]=Indicateurs::getTransferts();

        }

        return $t_indicateurs;
    }


    /* ************************** */
    /*    DIVERS
    /* ************************** */
    static function getUserIP()
    {
        $client  = @$_SERVER['HTTP_CLIENT_IP'];
        $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
        $remote  = $_SERVER['REMOTE_ADDR'];

        if(filter_var($client, FILTER_VALIDATE_IP))
        {
            $ip = $client;
        }
        elseif(filter_var($forward, FILTER_VALIDATE_IP))
        {
            $ip = $forward;
        }
        else
        {
            $ip = $remote;
        }

        return $ip;
    }


    static public function CleanMontant($str)
    {

        $str=str_replace(",",".",$str);
        $str=str_replace(" ","",$str);
        if($str=="") $str=0;
        return floatVal($str);
    }
       // Remplace tous les accents par leur équivalent sans accent.

    static function enleveaccents($str) {
        $ch0 = array(
            "œ"=>"oe",
            "Œ"=>"OE",
            "æ"=>"ae",
            "Æ"=>"AE",
            "À" => "A",
            "Á" => "A",
            "Â" => "A",
            "à" => "A",
            "Ä" => "A",
            "Å" => "A",
            "&#256;" => "A",
            "&#258;" => "A",
            "&#461;" => "A",
            "&#7840;" => "A",
            "&#7842;" => "A",
            "&#7844;" => "A",
            "&#7846;" => "A",
            "&#7848;" => "A",
            "&#7850;" => "A",
            "&#7852;" => "A",
            "&#7854;" => "A",
            "&#7856;" => "A",
            "&#7858;" => "A",
            "&#7860;" => "A",
            "&#7862;" => "A",
            "&#506;" => "A",
            "&#260;" => "A",
            "à" => "a",
            "á" => "a",
            "â" => "a",
            "à" => "a",
            "ä" => "a",
            "å" => "a",
            "&#257;" => "a",
            "&#259;" => "a",
            "&#462;" => "a",
            "&#7841;" => "a",
            "&#7843;" => "a",
            "&#7845;" => "a",
            "&#7847;" => "a",
            "&#7849;" => "a",
            "&#7851;" => "a",
            "&#7853;" => "a",
            "&#7855;" => "a",
            "&#7857;" => "a",
            "&#7859;" => "a",
            "&#7861;" => "a",
            "&#7863;" => "a",
            "&#507;" => "a",
            "&#261;" => "a",
            "Ç" => "C",
            "&#262;" => "C",
            "&#264;" => "C",
            "&#266;" => "C",
            "&#268;" => "C",
            "ç" => "c",
            "&#263;" => "c",
            "&#265;" => "c",
            "&#267;" => "c",
            "&#269;" => "c",
            "Ð" => "D",
            "&#270;" => "D",
            "&#272;" => "D",
            "&#271;" => "d",
            "&#273;" => "d",
            "È" => "E",
            "É" => "E",
            "Ê" => "E",
            "Ë" => "E",
            "&#274;" => "E",
            "&#276;" => "E",
            "&#278;" => "E",
            "&#280;" => "E",
            "&#282;" => "E",
            "&#7864;" => "E",
            "&#7866;" => "E",
            "&#7868;" => "E",
            "&#7870;" => "E",
            "&#7872;" => "E",
            "&#7874;" => "E",
            "&#7876;" => "E",
            "&#7878;" => "E",
            "è" => "e",
            "é" => "e",
            "ê" => "e",
            "ë" => "e",
            "&#275;" => "e",
            "&#277;" => "e",
            "&#279;" => "e",
            "&#281;" => "e",
            "&#283;" => "e",
            "&#7865;" => "e",
            "&#7867;" => "e",
            "&#7869;" => "e",
            "&#7871;" => "e",
            "&#7873;" => "e",
            "&#7875;" => "e",
            "&#7877;" => "e",
            "&#7879;" => "e",
            "&#284;" => "G",
            "&#286;" => "G",
            "&#288;" => "G",
            "&#290;" => "G",
            "&#285;" => "g",
            "&#287;" => "g",
            "&#289;" => "g",
            "&#291;" => "g",
            "&#292;" => "H",
            "&#294;" => "H",
            "&#293;" => "h",
            "&#295;" => "h",
            "Ì" => "I",
            "Í" => "I",
            "Î" => "I",
            "Ï" => "I",
            "&#296;" => "I",
            "&#298;" => "I",
            "&#300;" => "I",
            "&#302;" => "I",
            "&#304;" => "I",
            "&#463;" => "I",
            "&#7880;" => "I",
            "&#7882;" => "I",
            "&#308;" => "J",
            "&#309;" => "j",
            "&#310;" => "K",
            "&#311;" => "k",
            "&#313;" => "L",
            "&#315;" => "L",
            "&#317;" => "L",
            "&#319;" => "L",
            "&#321;" => "L",
            "&#314;" => "l",
            "&#316;" => "l",
            "&#318;" => "l",
            "&#320;" => "l",
            "&#322;" => "l",
            "Ñ" => "N",
            "&#323;" => "N",
            "&#325;" => "N",
            "&#327;" => "N",
            "ñ" => "n",
            "&#324;" => "n",
            "&#326;" => "n",
            "&#328;" => "n",
            "&#329;" => "n",
            "Ò" => "O",
            "Ó" => "O",
            "Ô" => "O",
            "Õ" => "O",
            "Ö" => "O",
            "Ø" => "O",
            "&#332;" => "O",
            "&#334;" => "O",
            "&#336;" => "O",
            "&#416;" => "O",
            "&#465;" => "O",
            "&#510;" => "O",
            "&#7884;" => "O",
            "&#7886;" => "O",
            "&#7888;" => "O",
            "&#7890;" => "O",
            "&#7892;" => "O",
            "&#7894;" => "O",
            "&#7896;" => "O",
            "&#7898;" => "O",
            "&#7900;" => "O",
            "&#7902;" => "O",
            "&#7904;" => "O",
            "&#7906;" => "O",
            "ò" => "o",
            "ó" => "o",
            "ô" => "o",
            "õ" => "o",
            "ö" => "o",
            "ø" => "o",
            "&#333;" => "o",
            "&#335;" => "o",
            "&#337;" => "o",
            "&#417;" => "o",
            "&#466;" => "o",
            "&#511;" => "o",
            "&#7885;" => "o",
            "&#7887;" => "o",
            "&#7889;" => "o",
            "&#7891;" => "o",
            "&#7893;" => "o",
            "&#7895;" => "o",
            "&#7897;" => "o",
            "&#7899;" => "o",
            "&#7901;" => "o",
            "&#7903;" => "o",
            "&#7905;" => "o",
            "&#7907;" => "o",
            "ð" => "o",
            "&#340;" => "R",
            "&#342;" => "R",
            "&#344;" => "R",
            "&#341;" => "r",
            "&#343;" => "r",
            "&#345;" => "r",
            "&#346;" => "S",
            "&#348;" => "S",
            "&#350;" => "S",
            "&#347;" => "s",
            "&#349;" => "s",
            "&#351;" => "s",
            "&#354;" => "T",
            "&#356;" => "T",
            "&#358;" => "T",
            "&#355;" => "t",
            "&#357;" => "t",
            "&#359;" => "t",
            "Ù" => "U",
            "Ú" => "U",
            "Û" => "U",
            "Ü" => "U",
            "&#360;" => "U",
            "&#362;" => "U",
            "&#364;" => "U",
            "&#366;" => "U",
            "&#368;" => "U",
            "&#370;" => "U",
            "&#431;" => "U",
            "&#467;" => "U",
            "&#469;" => "U",
            "&#471;" => "U",
            "&#473;" => "U",
            "&#475;" => "U",
            "&#7908;" => "U",
            "&#7910;" => "U",
            "&#7912;" => "U",
            "&#7914;" => "U",
            "&#7916;" => "U",
            "&#7918;" => "U",
            "&#7920;" => "U",
            "ù" => "u",
            "ú" => "u",
            "û" => "u",
            "ü" => "u",
            "&#361;" => "u",
            "&#363;" => "u",
            "&#365;" => "u",
            "&#367;" => "u",
            "&#369;" => "u",
            "&#371;" => "u",
            "&#432;" => "u",
            "&#468;" => "u",
            "&#470;" => "u",
            "&#472;" => "u",
            "&#474;" => "u",
            "&#476;" => "u",
            "&#7909;" => "u",
            "&#7911;" => "u",
            "&#7913;" => "u",
            "&#7915;" => "u",
            "&#7917;" => "u",
            "&#7919;" => "u",
            "&#7921;" => "u",
            "&#372;" => "W",
            "&#7808;" => "W",
            "&#7810;" => "W",
            "&#7812;" => "W",
            "&#373;" => "w",
            "&#7809;" => "w",
            "&#7811;" => "w",
            "&#7813;" => "w",
            "Ý" => "Y",
            "&#374;" => "Y",
            "?" => "Y",
            "&#7922;" => "Y",
            "&#7928;" => "Y",
            "&#7926;" => "Y",
            "&#7924;" => "Y",
            "ý" => "y",
            "ÿ" => "y",
            "&#375;" => "y",
            "&#7929;" => "y",
            "&#7925;" => "y",
            "&#7927;" => "y",
            "&#7923;" => "y",
            "&#377;" => "Z",
            "&#379;" => "Z"
            );
        $str = strtr($str,$ch0);
        return $str;
    }

    static function enleveaccents_old($chaine)
    {
     $string= strtr($chaine,
        "ÀÁÂàÄÅàáâàäåÒÓÔÕÖØòóôõöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜùúûüÿÑñ",
        "aaaaaaaaaaaaooooooooooooeeeeeeeecciiiiiiiiuuuuuuuuynn");
     return $string;
    }


}
