<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Authenticatable;


class PlanComptable extends Model {
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'plan_comptable';



	/* ************************* */
	/*           NOM             */
	/* ************************* */
    function getCompteNomCompletAttribute() {
    	return $label=$this->compte." ".$this->libelle;
    }


	/* ************************* */
	/*            DIVERS         */
	/* ************************* */
    function getActifHTMLAttribute() {
        $actif=$this->actif;
        $txt="";

        if($actif) {
	        $txt='<div class="custom-control custom-switch custom-switch-on-success">';
			$txt.='<input class="custom-control-input" checked="checked" type="checkbox" value="1">';
	        $txt.='<label class="custom-control-label" for="box_actif"></label>';
        	$txt.='</div>';
    	} else {
	        $txt='<div class="custom-control custom-switch custom-switch-off-danger">';
			$txt.='<input class="custom-control-input" checked="checked" type="checkbox" value="0">';
	        $txt.='<label class="custom-control-label" for="box_inactif"></label>';
	    }
        return $txt;
    }

    function getHasLinkAttribute() {
        $nb=GrandLivre::where("compte","=",$plancomptable->compte)->count();
        if($nb==0) $nb=Employeur::where("compte_aux","=",$plancomptable->compte)->count();

        return ($nb>0);
    }


	/* ************************* */
	/*        CREDIT / DEBIT
	/* ************************* */

    function getDepensesMontant($id_forfait) {
    	$montant=0;
    	$ecritures=GrandLivre::where('id_forfait','=',$id_forfait)
    		->where('compte','like',$this->compte.'%')
    		->get();
    	foreach($ecritures as $ecriture) {
    		$montant+=$ecriture->credit-$ecriture->debit;
    	}
    	return $montant;
    }

    function getDebit($date_deb,$date_fin,$jnx="") {
    	$montant=0;
    	if($date_deb==="") $date_deb=date('Y'."01-01");
    	if($date_fin==="") $date_fin=date('Y'."12-31");
    	$ecritures=GrandLivre::where('compte','like',$this->compte.'%')
    		->WhereBetween('date_doc', [$date_deb, $date_fin]);
    	if($jnx!='') $ecritures=$ecritures->where('journal','=',$jnx);
    	$ecritures=$ecritures->get();

    	foreach($ecritures as $ecriture) {
    		$montant+=$ecriture->debit;
    	}
    	return $montant;
    }

    function getCredit($date_deb,$date_fin,$jnx="") {
    	$montant=0;
    	if($date_deb==="") $date_deb=date('Y'."01-01");
    	if($date_fin==="") $date_fin=date('Y'."12-31");
    	$ecritures=GrandLivre::where('compte','like',$this->compte.'%')
    		->WhereBetween('date_doc', [$date_deb, $date_fin]);
    	if($jnx!='') $ecritures=$ecritures->where('journal','=',$jnx);
    	$ecritures=$ecritures->get();
    	
    	foreach($ecritures as $ecriture) {
    		$montant+=$ecriture->credit;
    	}
    	return $montant;
    }
}