<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Secteur extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'secteurs';
  
    public function getNbEmployeursAttribute()
    {

        $nb=DB::table('employeurs')
          ->where('employeurs.sec_id','=',$this->id)
          ->where('employeurs.statut','=','ACT')
          ->count();
        return $nb;
    }

    public function getNbEmployeurs($date="")
    {
        if($date=="") $date=date('Y')."-01-01";
        $employeurs=Employeur::where('employeurs.sec_id','=',$this->id)->get();
        $nb=0;
        foreach($employeurs as $employeur) {
          if($employeur->getNbEmployesMois($date)>0) $nb++;

        }
        return $nb;
    }
  
    public function getlisteEmployeurs($date="")
    {
        if($date=="") $date=date('Y')."-01-01";
        $employeurs=Employeur::where('employeurs.sec_id','=',$this->id)->get();
        $t_employeurs=array();
        foreach($employeurs as $employeur) {
          if($employeur->getNbEmployesMois($date)>0) $t_employeurs[]=$employeur->id;

        }
        return $t_employeurs;

    }

    public function getNbEmployesAttribute()
    {
       $annee=date('Y');
       $nb=DB::table(DB::raw('beneficiaires
            join employeurs on employeurs.id=beneficiaires.sonum
            join salaire on salaire.benum=beneficiaires.id'))
        ->select(DB::raw('count(*) as nb'))
        ->where('employeurs.statut','=','ACT')
        ->where('salaire.annee','=',( (date('m')<=3) ? ($annee-1) : $annee ) )
        ->where('employeurs.sec_id','=',$this->id) 
        ->value('nb');
        return $nb;
    }  

    public function getNbEmployes($date="")
    {
        if($date=="") $date=date('Y')."-01-01";
        $employeurs=Employeur::where('employeurs.sec_id','=',$this->id)->get();
        $nb=0;
        foreach($employeurs as $employeur) {
          $nb+=$employeur->getNbEmployesMois($date);
        }
        return $nb;
    } 


    public function getNbEmployeursAnnee($annee="")
    {
      if($annee=="") $annee=date('Y');
      $nb=0;
      $nb=DB::table('employeurs')
        ->where('employeurs.sec_id','=',$this->id)
        ->where('employeurs.statut','=','ACT')
        ->whereRaw("YEAR(date_deb) <='".$annee."'".
          " AND (date_fin='0000-00-00' OR YEAR(date_fin) >='".$annee."')")
        ->count();
      return $nb;
    }


 public function getNbEmployesAnnee($annee="")
    {
       if($annee=="") $annee=date('Y');
       $nb=DB::table(DB::raw('beneficiaires
              join employeurs on employeurs.id=beneficiaires.sonum
              join salaire on salaire.benum=beneficiaires.id'))
        ->select(DB::raw('count(*) as nb'))
        ->where('employeurs.statut','=','ACT')
        ->where('salaire.annee','=',( (date('m')<=3) ? ($annee-1) : $annee ) )
        ->where('employeurs.sec_id','=',$this->id) 
        ->value('nb');

        return $nb;
    }  


 public function getMasseAnnee($annee="")
    {
        if($annee=="") $annee=date('Y');
        $masse=0;
        $employeurs=Employeur::where('sec_id','=',$this->id)
          ->where('statut','=','ACT')
          ->whereRaw("YEAR(date_deb) <='".$annee."'".
            " AND (date_fin='0000-00-00' OR YEAR(date_fin) >='".$annee."')")
          ->get();
        foreach($employeurs as $employeur) {
          $masse+=$employeur->getMasseSalairesActifs($annee);
        }
        return $masse;
    }  


 public function getMasseSalariale($date="")
    {
        if($date=="") $date=date('Y')."-01-01";
        $employeurs=Employeur::where('employeurs.sec_id','=',$this->id)->get();
        $nb=0;
        foreach($employeurs as $employeur) {
          $nb+=$employeur->getMasseSalarialeMois($date);
        }
        return $nb;
    } 



    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }
}
