@include('forms.fbncheader')
@include('forms.fdatatables')

<div class="col-lg-8 col-lg-offset-1">
    <h1><i class="fa fa-roles"></i>Administration des Rôles</h1>
 
    <div class="">
        <table id="_table" class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>Nom</th>
                    <th width='1%'>Utilisateurs</th>
                    <th width='1%'>Statut visualisé par défaut</th>
                    <th width='185px'></th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($roles as $role)
                <tr>
                    <td nowrap>{!! $role->name !!}</td>
                    <td nowrap style='font-size:10px'>{!! $role->getusers() !!}</td>
                    <td>{!! $role->benef_statut !!}</td>

                    
                    <td nowrap>
                    @if($user->can("ROL_MAJ")|| $user->hasrole("ADMINISTRATEUR"))
                        <a href="./roles/{!! $role->id !!}/edit" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                    @endif
                    @if($user->SysAdmin)
                        {!! Form::open(['url' => '/acces/roles/' . $role->id, 'method' => 'DELETE']) !!}
                        {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                        {!! Form::close() !!}
                    @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>
 
 @if($user->can("ROL_AJO")|| $user->hasrole("ADMINISTRATEUR"))
     <div>
        <h4><a href="./roles/create" class="btn btn-success">Ajouter un Rôle</a></h4>
    </div> 
@endif


    
 
</div>

</body></html>

@include('forms.fdatatables_script')