@extends('layouts.dash')
@section('title','Grand Livre')
@section('title_card',"")
@section('subtitle_card',"")
@section('content')


    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif  
        
        <div class="card-header bg-warning">
            <h3 class="card-title"><i class="fa fa-plan"></i>Liste des Journaux
                @if($exercice_encours!=$exercice)
                <small>Historique Non modififable</small>
                @endif
            </h3>
        </div>
        <div class="card-body">
            {!! html()->hidden('checklist','')->attributes(['id'=>'checklist']) !!}
            <div class="row form-group"> 
                 <div class="col-md-2"> 
                    {!! html()->select('exercice',$exercices,$exercice)->attributes(['id' => 'exercice','class' => 'form-control']) !!}
                </div>
            </div>

            <div class='row col-lg-max' style="padding-top:5px">
                <div class="alert" style="padding-top:0px">
                    <table id="_table" style="background-color:white" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th nowrap width='1%'></th>
                                <th nowrap width='1%'>N°Journal</th>
                                <th width='1%' >Date</th>
                                <th nowrap width='1%'>N°Compte</th>
                                <th width='1%'>Référence</th>
                                <th>Libelle</th>
                                <th width='5%'>Débit</th>
                                <th width='5%'>Crédit</th>
                                <th width='1%'>Enc</th>
                                <th width='1%'>
                                    @if($user->can("JOU_AJO") || $user->HasRole("ADMINISTRATEUR"))
                                     <div>
                                        <a href="{!! url('/compta_old/journal/create') !!}" class="btn btn-sm btn-success">
                                            Ajouter&nbsp;une&nbsp;écriture</a>
                                        &nbsp;
                                        <span >
                                            <a href="#" class="btn btn-sm btn-success" id='bt_compenser' disabled='disabled' onclick='compenser();return;'>
                                                Compenser&nbsp;la&nbsp;sélection</a>
                                        </span>
                                    </div> 
                                    @endif
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $total=["debit"=>0,"credit"=>0]; ?>
                            @foreach ($journaux as $journal)
                            <?php
                                $total["debit"]+=$journal->debit;
                                $total["credit"]+=$journal->credit;
                            ?>
                            <tr>
                                <td align="center" style="color:grey;padding:0px;margin:0px">
                                    @if($journal->IsCompensable)
                                        {!! html()->checkbox('box_'.$journal->id, '1',false)->attributes(['id'=>'box_'.$journal->id,'onclick'=>"check($journal->id)"]); !!}
                                    @endif
                                </td>
                                <td style="color:grey;font-style:italic">{!! $journal->id !!}</td>
                                <td align="center">{!! $journal->date !!}</td>
                                <td align="center">{!! $journal->numcpt!!}</td>
                                <td nowrap>{!! $journal->ref!!}</td>
                                <td>{!! $journal->libelle!!}</td>
                                <td nowrap align="right" style="color:darkred;font-weight:bold">{!! number_format($journal->debit,0,","," ") !!}</td>
                                <td nowrap align="right" style="color:darkblue;font-weight:bold">{!! number_format($journal->credit,0,","," ") !!}</td>
                                <td nowrap align="right">{!! $journal->enc!!}</td>       
                                <td nowrap>
                                </td>  
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

        
@section('scripts')
    <script>
        $(document).ready(function() {

            $('#exercice').on('change', function() {
                location.href="{!! url('compta_old/journal_exercice/') !!}"+"/"+$('#exercice').val();
            });
        });
    </script>

    <script>
        //Complete la liste des boites cochées
        function check(id) {
            var list=$("#checklist").val();
            if($("#box_"+id).prop('checked')) {
                var value=id+"~";
                if(list.indexOf(id+"~")==-1) {
                    $("#checklist").val(list+value);
                }
            } else {
                var pos=list.split("~");
                var new_list="";
                for(var i=0;i<pos.length;i++) {
                    if((pos[i]!=id)&&(pos[i]!="")) new_list+=pos[i]+"~";
                }
                $("#checklist").val(new_list);
            }
            var list=$("#checklist").val();

            if(list=="") $("#bt_compenser").attr('disabled','disabled');   
            else $("#bt_compenser").removeAttr('disabled'); 

            $("#bt_compenser").attr('disabled','disabled');   
        }

        function compenser(id) {
            var list=$("#checklist").val();
            if(list=="") return;
            var url="{!! url('/compta_old/journal_compense') !!}"+"/"+list;
            $.fancybox.open({ 
                'autoScale': true,
                'href': url, 
                'type': 'ajax',
                'width': '70%',
                'height': '70%',
                'autoSize': false,
                'autoScale': false,
                'transitionIn': 'elastic',
                'transitionOut': 'elastic',
                'speedIn': 500,
                'speedOut': 300,
                'autoDimensions': false,
                'centerOnScroll': true,

               afterClose: function () { // USE THIS IT IS YOUR ANSWER THE KEY WORD IS "afterClose"
                    parent.location.reload(true);
                }
            });
            return;
        }
    </script>


    <script>
      $(function () {
        $("#_table").DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": true,
          "ordering": true,
          "info": true,
          "responsive": false,
          "autoWidth": false,
          "fixedHeader": true,
           oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }

            },
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
            "aaSorting": [
                [1,'desc']
            ],

            "aoColumnDefs": [
                { "sTypes": "numeric", "aTargets": [ 3 ] },

            ],
            "buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv",
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

      });
    </script>


@endsection