@extends('layouts.master')
 
@section('title') Mise à jour d'un Compte  @stop
 
@section('content')
 
<div class='col-lg-8 col-lg-offset-2'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-user'></i>Compte {!! $plan->numcpt !!}</h1>
 
    {!! Form::model($plan, ['plan' => 'form', 'url' => '/compta/plan/' . $plan->id

        , 'class' => 'form-horizontal', 'method' => 'PUT']) !!}
  


    <div class='form-group'>
        <div class="col-md-3">
            <div class="has-success has-feedback">
                <div class="input-group">
                    <span class="input-group-addon">N°Compte</span>
                    <input readonly="readonly" type="text" class="form-control" name="numcpt" id="numcpt" 
                    value='{!! $plan->numcpt !!}' />
                </div>
           </div>
       </div>
    </div>

    <div class='form-group'>
        <div class='col-md-7'>
        {!! Form::label('nomcpt', 'Nom') !!}
        {!! Form::text('nomcpt', null, ['placeholder' => 'Nom d compte', 'class' => 'form-control']) !!}
        </div>
    </div>

    <div class='form-group'>
        <div class="col-xs-2">
            {!! Form::label('categ', 'Compte') !!}
            <br/>
            {!! Form::select(
                    'categ',
                    ['F'=>'CCPF (F)','R' => 'CLR (R)','A' => 'AS/AV (A)','V' => 'Autre (V)'],
                    null,['class' => 'selectpicker','data-width' => "100%"]) 
            !!}
        </div>


        <div class="col-xs-2">
            {!! Form::label('categ_bilan', 'Catég. pour Bilan') !!}
            <br/>
            {!! Form::select(
                    'categ_bilan',
                    ['A' => 'Actif','P' => 'Passif'],
                    null,['class' => 'selectpicker','data-width' => "100%"]) 
            !!}
        </div>


        <div class="col-xs-3">
            {!! Form::label('categ_cr', 'Catég. pour C.R.') !!}
            <br/>
            {!! Form::select(
                    'categ_cr',
                    [''=>'Choisir une catégorie',
                    'CF'=>'Charges CCPF résultat ccpf',
                    'CR' => 'Charges CLR résultat clr',
                    'CS' => 'Charges aides sociales résultat social',
                    'PF'=>'Produits CCPF résultat ccpf',
                    'PR' => 'Produits CLR résultat clr',
                    'PS' => 'Produits aides sociales résultat social',
                    ],
                    null,['class' => 'selectpicker','data-width' => "100%"]) 
            !!}
        </div>
<!--
        <div class='col-xs-2'>
                {!! Form::label('poste', 'Poste') !!}
                {!! Form::text('poste', null, ['placeholder' => 'Poste', 'class' => 'form-control']) !!}
        </div>
-->
    </div>


    <div class='form-group'> 
        <!--
        <div class="col-xs-4">
            {!! Form::label('bilan', 'Visualisation au Bilan') !!}
            <br/>
            {!! Form::select(
                    'bilan',
                    [' ' => 'Aucun','F'=>'CCPF','R' => 'CLR','A' => 'AS','A' => 'AV'],
                    null,['class' => 'selectpicker','data-width' => "100%"]) 
            !!}
        </div>
    -->

        <div class="col-xs-4">
            {!! Form::label('amort', 'Compte Amortisssement') !!}
            {!! 
            Form::select(
                'amort',[" "=>"Aucun"]+$comptes,
                null,
                ['class' => 'selectpicker','data-width' => "100%"]
            ) 
            !!}
        </div>
    </div>




    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-warning">
                <div class="input-group-addon" style="width:100px">Budget</div>
                {!! Form::text('budget', null, ['placeholder' => 'Budget', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>


    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-error">
                <div class="input-group-addon" style="width:100px">Débit <i>(Calculé)</i></div>
                {!! Form::text('debit_calc', $plan->getDebitCalc(), ['readonly', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="col-md-4">
            <div class="input-group has-success">
                <div class="input-group-addon" style="width:100px">Crédit <i>(Calculé)</i></div>
                {!! Form::text('credit_calc', $plan->getCreditCalc(), ['readonly', 'class' => 'text-right form-control'])!!}
                <div class="input-group-addon">CFP</div>
            </div>
        </div>
    </div>


<div class="col-sm-9">
    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
    </div>
 </div>

    {!! Form::close() !!}
 
</div>
 
@stop