@extends('layouts.dash')
@section('title','Grand Livre')
@section('title_card',"")
@section('subtitle_card',"")
@section('content')


    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif  
        
        <div class="card-header bg-warning">
            <h3 class="card-title">Plan comptable <small>{!! $exercice !!}</h3>
        </div>
        <div class="card-body">
            <div class="row form-group"> 
                 <div class="col-md-2"> 
                    {!! html()->select('exercice',$exercices,$exercice)->attributes(['id' => 'exercice','class' => 'form-control']) !!}
                </div>
            </div>
            <div class="text-right" style="margin-right:10px;padding-top:-20px">
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal">
                Imprimer le plan comptable
                </button>
            </div>
            <div class="table-responsive">
                <table id="_table" style="background-color:white"  class="table table-condensed table-striped table-bordered">
                    <thead>
                        <tr>
                            <th width='1%'>N°compte</th>
                            <th >Nom</th>
                            <th width='1%'>Compte</th>
                            <th width='1%'>Catég.Bilan</th>
                            <th width='1%'>Catég.CR</th>
                            <th width='1%'>Bilan</th>
                            <th width='1%'>Amort.</th>
                            @if($exercice==$exercice_encours)
                                <th width='1%'>Budget</th>
                            @endif  
                            <th width='1%'>Débit</th>
                            <th width='1%'>Crédit</th>
                            <th width='1%'>
                            @if($exercice==$exercice_encours)
                                Solde
                            @else
                                Solde<br/>(crédit-débit)
                            @endif
                            </th>
                            <th width='1px'><div>
                                @if($user->can("PLA_AJO") || $user->HasRole("ADMINISTRATEUR"))
                                        <h4><a href="{!! url('/compta_old/plan/create') !!}" class="btn btn-success">
                                                Ajouter un compte</a></h4>
                                @endif                             
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($plans as $plan)
                        <tr>
                            <td nowrap>
                                @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                    <a href="{!! url('compta_old_plan_visu/'.$plan->id.'/'.$exercice) !!}" 
                                        class="btn bg-success" style="font-weight:bold;font-size:120%">
                                @endif
                                {!! $plan->numcpt !!}
                                @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                    </a>
                                @endif
                            </td>
                            <td >{!! $plan->nomcpt !!}</td>
                            <td nowrap>{!! $plan->categ!!}</td>
                            <td nowrap>{!! $plan->categ_bilan!!}</td>
                            <td nowrap>{!! $plan->categ_cr!!}</td>
                            <td nowrap>{!! $plan->bilan!!}</td>
                            <td nowrap>{!! $plan->amort!!}</td>
                            @if($exercice==$exercice_encours)
                            <td nowrap align='right'>{!! number_format($plan->budget,0,",","") !!}</td>
                            @endif
                            <td nowrap align='right'>{!! number_format($plan->getDebitCalc($exercice),0,",","") !!}</td>
                            <td nowrap align='right'>{!! number_format($plan->getCreditCalc($exercice),0,",","") !!}</td>
                            <td nowrap align='right'>
                                @if($exercice==$exercice_encours)
                                    {!! number_format($plan->getSoldeTotCalc($exercice),0,",","") !!}
                                @else
                                    {!! number_format($plan->getSoldeCalc($exercice),0,",","") !!}                  
                                @endif
                            </td>
                            <td nowrap>
                                <a  alt="Grand livre" href="{!! url('/compta_old_grandlivre').'/'.$plan->numcpt.'/'.$exercice !!}" target="_blank" 
                                    class="btn btn-default glyphicon glyphicon-book" style="background-color:peachpuff">
                                </a>

                                @if( $user->can("PLA_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                                    <a href="{!! url('/compta_old/plan').'/'.$plan->id.'/edit' !!}" 
                                            class="btn btn-info glyphicon glyphicon-pencil"></a>
                                @endif 

                                @if( ($user->can("PLA_SUP") || $user->HasRole("ADMINISTRATEUR"))  
                                    &&($plan->getNbEcrituresAttribute()==0) ) 

                                    {{ html()->form('DELETE', url('/compta_old/plan/'. $plan->id))->open() }}
                                        <button type="submit" class="btn btn-danger glyphicon glyphicon-trash">
                                        </button>
                                    {{ html()->form()->close() }}
                                @endif 
                            
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
             <div>
                <h4>
                    @if($user->can("PLA_AJO") || $user->HasRole("ADMINISTRATEUR"))
                        <a href="{!! url('/compta_old/plan/create') !!}" class="btn btn-success">
                            Ajouter un compte</a>
                    @endif

                    <!-- Button trigger modal -->
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal">
                    Impression du plan par catégorie
                    </button>
                </h4>
            </div>
            <!-- Modal -->
            <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
              <div class="modal-dialog" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="myModalLabel">Impression du plan par catégorie</h4>
                  </div>
                  <div class="modal-body form-horizontal" style="margin-bottom:40px;margin-top:20px">
                        <div class="col-xs-6 h4">
                            {!! html()->label('Veuillez choisir la catégorie','imp_categ') !!}
                         </div>
                        <div class="col-xs-3" style="">
                            {!! html()->select('categ',['*' => 'Toutes','A' => 'A','F' => 'F','R' => 'R','V' => 'V'],'')
                                ->attributes(['id'=>'imp_categ','class' => 'form-control']) !!}
                        </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
                    <button type="button" class="btn btn-primary" id='btn_imprimer' onclick="imprimer();return;">Imprimer</button>
                  </div>
                </div>
              </div>
            </div>
        </div>
    </div>
@endsection

        
@section('scripts')
    <script>
        $(document).ready(function() {
            $('#exercice').on('change', function() {
                location.href="{!! url('compta_old/plan_annee/') !!}"+"/"+$('#exercice').val();
            });

            $('#btn_imprimer').click(
                function imprimer() {
                    var categ=$('#imp_categ').val();
                    if(categ=="") return;
                    $('#myModal').modal('hide');
                    var url="{!! url('/compta_old_plan') !!}"+"/"+categ+"/"+'{!! $exercice !!}'; 
                    window.open(url,'_blank');
                    return;
                });

            var table =$('#_table').dataTable( {
                bAutoWidth: false,
                bPaginate: false,
                bInfo: true,
                bFilter: true,
                deferRender:    true,
                //scrollY:        400,
                scrollCollapse: false,
                scroller:       false,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "decimal": ",",
                    "thousands": " ",
                    "sSearch": "Chercher",

                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',
                        print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                        }
                    }

                },
                "aoColumnDefs": [{ "sTypes": "numeric", "aTargets": [ 3 ] },],
                dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                    "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                buttons: [ 
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} },
                    'colvis'
                ],
            });
        } );
    </script>
@endsection









