@include('forms.fbncheader')
@include('forms.fdatatables')

        
<div class="col-lg-max col-lg-offset-1 container-fluid">
    <h1><i class="fa fa-plan"></i>Liste des Journaux</h1>
    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>N°Journal</th>
                    <th >Date</th>
                    <th width='1%'>N°Compte</th>
                    <th width='1%'>Référence</th>
                    <th width='1%'>Libelle</th>
                    <th width='1%'>Débit</th>
                    <th width='1%'>Crédit</th>
                    <th width='1%'>Enc</th>
                    <th width='185px'></th>
                </tr>
            </thead>
 

            <tbody>
                @foreach ($journaux as $journal)
                <tr>
                    <td nowrap>{!! $journal->id !!}</td>
                    <td nowrap>{!! $journal->date !!}</td>
                    <td nowrap>{!! $journal->numcpt!!}</td>
                    <td nowrap>{!! $journal->ref!!}</td>
                    <td nowrap>{!! $journal->libelle!!}</td>
                    <td nowrap>{!! number_format($journal->debit,0,","," ") !!}</td>
                    <td nowrap>{!! number_format($journal->credit,0,","," ") !!}</td>
                    <td nowrap>{!! $journal->enc!!}</td>
                    <td nowrap>
                    @if($user->can("JOU_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                        <a href="{!! url('/compta/journal').'/'.$journal->id.'/edit' !!}" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                    @endif 
                    @if($user->can("JOU_SUP") || $user->HasRole("ADMINISTRATEUR"))   
                        {!! Form::open(['url' => '/compta/journal/' . $journal->id, 'method' => 'DELETE']) !!}
                        {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                        {!! Form::close() !!}
                    @endif 
                    </td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>
@if($user->can("JOU_AJO") || $user->HasRole("ADMINISTRATEUR"))
     <div>
        <h4><a href="{!! url('/compta/journal/create') !!}" class="btn btn-success">
            Ajouter un journal</a></h4>
    </div> 
@endif

</div>


</body></html>
@include('forms.fdatatables_script')