@extends('layouts.dash')
@section('title') Plan @stop
 
@section('content')
    <div class="card card-info">
        <div class="card-header">
            <h2>Consultation d'un Compte</h2>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($plan)->open() }}
                <div class='row form-group'>
                    <div class="col-md-3">
                        <div class="has-success has-feedback">
                            <div class="input-group">
                                <span class="input-group-addon">N°Compte</span>
                                <input readonly="readonly" type="text" class="form-control" name="numcpt" id="numcpt" value='{!! $plan->numcpt !!}' />
                            </div>
                       </div>
                   </div>
                </div>
                <div class='row form-group'>
                    <div class='col-md-8'>
                    {!! html()->label( 'Nom','nomcpt') !!}
                    {!! html()->text('nomcpt', null)->attributes(['readonly', 'class' => 'form-control']) !!}
                    </div>
                </div>
                <div class='row form-group'>
                    <div class="col-md-2">
                        {!! html()->label( 'Compte','categ') !!}
                        {!! html()->text('categ', $plan->CategLibelle)->attributes(['readonly','class' => 'form-control']) !!}
                    </div>
                    <div class="col-md-2">
                        {!! html()->label( 'Catég. Bilan','categ_bilan') !!}
                        {!! html()->text('categ_bilan', $plan->CategBilanLibelle)->attributes(['readonly','class' => 'form-control']) !!}
                    </div>
                    <div class="col-md-4">
                        {!! html()->label( 'Catég. Compte de Résultat','categ_cr') !!}
                        {!! html()->text('categ_cr', $plan->CategCRLibelle)->attributes(['readonly','class' => 'form-control']) !!}
                    </div>
                </div>
                <div class='row form-group'> 
                    <div class="col-md-4">
                        {!! html()->label('Compte Amortisssement','amort') !!}
                        {!! html()->select('amort',[" "=>"Aucun"]+$comptes,null)->attributes(['class' => 'selectpicker','data-width' => "100%",'disabled']) !!}
                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-md-4">
                        <div class="input-group has-warning">
                            <div class="input-group-addon" style="width:100px">Budget</div>
                            {!! html()->text('budget', null)->attributes(['readonly', 'class' => 'text-right form-control'])!!}
                        </div>
                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-md-4">
                        <div class="input-group has-error">
                            <div class="input-group-addon" style="width:100px">Débit <i>(Calculé)</i></div>
                            {!! html()->text('debit_calc', $plan->getDebitCalc())->attributes(['readonly', 'class' => 'text-right form-control'])!!}
                        </div>
                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-md-4">
                        <div class="input-group has-success">
                            <div class="input-group-addon" style="width:100px">Crédit <i>(Calculé)</i></div>
                            {!! html()->text('credit_calc', $plan->getCreditCalc())->attributes(['readonly', 'class' => 'text-right form-control'])!!}
                        </div>
                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-sm-9">
                        <div class='form-group'><br/>
                            <a class="btn btn-warning" href="{!! url('compta_old/plan') !!}">
                                Retour</a>

                        <a href="{!! url('/compta_old_grandlivre').'/'.$plan->numcpt.'/'.$exercice !!}" target="_blank" class="btn btn-danger">
                            Grand Livre</a>
                    </div> 
                </div>
            {{ html()->form()->close() }}
        </div>
    </div>
@endsection



@section('title') Consultation d'un Compte  @stop
 
@section('content')
 

