@extends('layouts.dash')

@section('title') Balance @stop
@section('title_card') Balance @stop
@section('subtitle_card',"")

@section('content')
    <div class="card">

        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif  

        <div class="card-header">
            <form class="form-inline">
                <div class='form-group'>
                    {!! html()->label('Date de début','date_debut') !!}&nbsp;&nbsp;
                    <div class='input-group date' id='datepicker_date_debut'>
                    {!! html()->text('date_debut', isset($date_deb)?$date_deb:'01/01/'.date('Y'))
                        ->attributes(['id'=>'date_debut','size'=>'10','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='form-group ml-4' style=''>
                    {!! html()->label('Date de fin','date_fin') !!}&nbsp;&nbsp;
                    <div class='input-group date' id='datepicker_date_fin'>
                    {!! html()->text('date_fin', isset($date_fin)?$date_fin:'31/12/'.date('Y'))
                        ->attributes(['id'=>'date_fin','size'=>'10','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='col-md-2 p-4' style="margin-top:5px" >
                    <a id='btn_filtre' class="btn btn-primary"  href="#" ><i class="fas fa-search"></i>&nbsp;Rechercher</a>
                </div>
            </form>
            <div class=" form-inline">
                <form class="form-group">
                    {!! html()->label('Journal','jnx') !!}&nbsp;&nbsp;
                    {!! html()->select('jnx')->options($liste_journaux)
                        ->value(isset($jnx)?$jnx:"")
                        ->placeholder('')
                        ->attributes(['id'=>'jnx','class' => 'form-control'])  !!}
                </form>
            </div>
        </div>

        <div class="card-body">
            <table id="_table" width="100%" class="table table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>CompteTri</th>
                        <th width='1%'>Compte</th>
                        <th>Designation</th>
                        <th width='1%'>Débit</th>
                        <th width='1%'>Crédit</th>
                        <th width='1%'>Solde</th>
                    </tr>
                </thead>
                <tbody>
                    @php $total_debit=0;$total_credit=0;$solde=0; @endphp
                    @foreach ($t_plan as $key=>$ligne)
                    @php
                        $total_debit+=$ligne['debit'];
                        $total_credit+=$ligne['credit'];
                        $solde=$total_debit-$total_credit;
                    @endphp
                    <tr class="p_titre">
                        <td nowrap>{!! str_pad($ligne['compte'],7,'0',STR_PAD_RIGHT) !!}</td>
                        <td nowrap >
                            <a href="{!! url('comptes_filtre/'.$ligne['compte'].'/0/'.$date_debUS.'/'.$date_finUS) !!}" target='_blank'>
                                {!! $ligne['compte'] !!}
                            </a>
                        </td>
                        <td>{!! $ligne['compte_libelle'] !!}</td>
                        <td nowrap align="right" style='font-style:italic'>{!! $ligne['debit'] !!}</td>
                        <td nowrap align="right">{!! $ligne['credit'] !!}</td>
                        <td nowrap align="right">{!! $ligne['solde'] !!}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="3"></th>
                        <th width='1%'style="text-align:right;color:darkred">{{ $total_debit }}</th>
                        <th width='1%'style="text-align:right;color:darkgreen">{{ $total_credit }}</th>
                        <th width='1%'  style="text-align:right;color:{{ ($solde<0)?'darkred':'darkgreen' }}">{{ $total_debit-$total_credit }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
<script>
  $(function () {
    $('#datepicker_date_debut').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
    });

    $('#datepicker_date_fin').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
    });

    $('#jnx').change( function() {
        filtre();
    });

    $('#btn_filtre').click( function() {
        filtre();
    });

    function filtre() {
        var select_jnx = $('#jnx').val();
        var date_dep=$('#date_debut').val();
        var date_fin=$('#date_fin').val();
        var t_date_dep = date_dep.split('/');
        date_dep= t_date_dep[2]+"-"+t_date_dep[1]+"-"+t_date_dep[0];
        var t_date_fin = date_fin.split('/');
        date_fin= t_date_fin[2]+"-"+t_date_fin[1]+"-"+t_date_fin[0];
        if(select_jnx=="") select_jnx=0;
        var url="{!! url('balance_filtre/') !!}/"+select_jnx+"/"+date_dep+"/"+date_fin ; 
        location.href=url;
    }

    $("#_table").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": false,
      "responsive": true, 
      "autoWidth": true,
      iDisplayLength:20,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }
        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",

        "buttons": ["copy", "excel", "colvis"], //"print", "pdf", "csv", 
        "aaSorting": [
            [0,'asc']
        ],
        "columnDefs": [
            { "targets": [ 4], "orderable": false,"searchable": false},
            { "targets": [ 0], "visible": false},
            { "targets": [ 1-4], "orderable": false},
        ]
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
@endsection