@extends('layouts.dash')

@section('title','Grand Livre')
@section('title_card',"")
@section('subtitle_card',"")
@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif  
        
        <div class="card-header bg-primary">
            <h3 class="card-title">Ecritures du {{ $date_deb." au ".$date_fin}}</h3>
        </div>
        <div class="card-body">
            <div class="col-md-12"">
                <div class="form-group row">
                    <div class='col-md-2'>
                        {!! html()->label('Date de début','date_debut') !!}
                        <div class='input-group date' id='datepicker_date_debut'>
                        {!! html()->text('date_debut', isset($date_deb)?$date_deb:'01/01/'.date('Y'))
                            ->attributes(['id'=>'date_debut','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                            <span class='input-group-addon'>
                                <span class='glyphicon glyphicon-calendar'></span>
                            </span>
                        </div>
                    </div>
                    <div class='col-md-2'>
                        {!! html()->label('Date de fin','date_fin') !!}
                        <div class='input-group date' id='datepicker_date_fin'>
                        {!! html()->text('date_fin', isset($date_fin)?$date_fin:'31/12/'.date('Y'))
                            ->attributes(['id'=>'date_fin','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                            <span class='input-group-addon'>
                                <span class='glyphicon glyphicon-calendar'></span>
                            </span>
                        </div>
                    </div>
                    <div class='col-md-2 p-4' style="margin-top:5px" >
                        <a id='btn_filtre' class="btn btn-primary"  href="#" ><i class="fas fa-search"></i>&nbsp;Rechercher</a>
                    </div>
                </div>

                <div class="form-group row">
                     @include("comptabilite.grandlivre.liste_ecritures_base")  
                </div>
            </div>
        </div>
    </div>
@endsection


@section('scripts')
<script type="text/javascript">
    $(function () {
        $('#datepicker_date_debut').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });

        $('#datepicker_date_fin').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });


        $('#btn_filtre').click( function() {
            filtre();
        });

        function filtre() {
            var date_dep=$('#date_debut').val();
            var date_fin=$('#date_fin').val();
            var t_date_dep = date_dep.split('/');
            date_dep= t_date_dep[2]+"-"+t_date_dep[1]+"-"+t_date_dep[0];
            var t_date_fin = date_fin.split('/');
            date_fin= t_date_fin[2]+"-"+t_date_fin[1]+"-"+t_date_fin[0];
            var url="{!! url('ecritures_filtre/') !!}/"+date_dep+"/"+date_fin ; 
            location.href=url;
        }


        $("#_table").DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": true,
          "ordering": true,
          "info": true,
          "responsive": false,
          "autoWidth": false,
          "fixedHeader": true,
           oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }

            },
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
            buttons: [
                { extend: 'copyHtml5', footer: true },
                { extend: 'excelHtml5', footer: true },
                { extend: 'csvHtml5', footer: true },
            ]
            //"buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv"
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

    });
</script>
@endsection