@extends('layouts.dash')
@section('title','Journaux')
@section('subtitle_card',"")
@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif  
        
        <div class="card-header bg-info">
            <h3 class="card-title">Journaux - <i>{!! (isset($view) && ($view=='transactions'))?'Vue par transaction':'Vue par écritures' !!}</i> - du {{ $date_deb." au ".$date_fin}}</h3>
        </div>

        <div class="card-body">
            <form class="form-inline">
                <div class='form-group col-md-7'>
                    {!! html()->label('Date de début','date_debut') !!}&nbsp;&nbsp;
                    <div class='input-group date' id='datepicker_date_debut'>
                    {!! html()->text('date_debut', isset($date_deb)?$date_deb:'01/01/'.date('Y'))
                        ->attributes(['id'=>'date_debut','size'=>'10','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>

                    &nbsp;&nbsp;{!! html()->label('Date de fin','date_fin') !!}&nbsp;&nbsp;
                    <div class='input-group date' id='datepicker_date_fin'>
                    {!! html()->text('date_fin', isset($date_fin)?$date_fin:'31/12/'.date('Y'))
                        ->attributes(['id'=>'date_fin','size'=>'10','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                    &nbsp;&nbsp;
                    <a style="margin-top:4px;margin-left:25px"  id='btn_filtre' class="btn btn-primary"  href="#" ><i class="fas fa-search"></i>&nbsp;Rechercher</a>
                </div>
                <div class='form-group col-md-3'></div>
                <div class='form-group col-md-2'>
                    @if($user->hasRole("ADMINISTRATEUR") || $user->can("GLI_MAJ"))
                        &nbsp;&nbsp;<a  style="" title="Nouvelle transaction" href="{!! url('grand_livre/create') !!}" class="btn  btn-success"><i class="fas fa-add"></i>&nbsp;Nouvelle transaction</a> 
                    @endif 
                </div>
            </form>

            <form class="form-inline mt-2">
                <div class="form-group  col-md-12">
                    {!! html()->label('Journal','select_jnx') !!}&nbsp;&nbsp;
                    {!! html()->select('select_jnx')->options($liste_journaux+["ALL"=>"Tous"])
                        ->value(isset($jnx)?$jnx:"")
                        ->placeholder('Choisir un journal')
                        ->attributes(['id'=>'select_jnx','class' => 'form-control'])  !!}

                    
                    <a id='btn_transactions' title="Transactions"  style="margin-left:40px" class="btn btn-{!! ($view=='transactions')?'info':'default' !!}" href="#">
                        <i class="fas fa-align-left"></i>
                    </a>&nbsp;&nbsp;
                    <a id="btn_ecritures" title="Ecritures" class="btn btn-{!! ($view=='ecritures')?'info':'default' !!}" href="#">
                        <i class="fas fa-align-justify"></i>
                    </a>

                </div>
            </form>
            @if(isset($view) && ($view=='transactions'))
                @include("comptabilite.grandlivre.liste_transactions")
            @else
                @include("comptabilite.grandlivre.liste_ecritures")
            @endif
        </div>
    </div>
@endsection


@section('scripts')


    <script type="text/javascript">
    $(function () {
        $('#datepicker_date_debut').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });

        $('#datepicker_date_fin').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });

        $('#select_jnx').change( function() {
            filtre('{{ $view }}');
        });


        $('#btn_filtre').click( function() {
            filtre('{{ $view }}');
        });

        $('#btn_ecritures').click( function() {
            filtre('ecritures');
        });

        $('#btn_transactions').click( function() {
            filtre('transactions');
        });


        function filtre(view="") {
            var select_jnx = $('#select_jnx').val();
            if(select_jnx=="") select_jnx=0;
            var date_dep=$('#date_debut').val();
            var date_fin=$('#date_fin').val();
            var t_date_dep = date_dep.split('/');
            date_dep= t_date_dep[2]+"-"+t_date_dep[1]+"-"+t_date_dep[0];
            var t_date_fin = date_fin.split('/');
            date_fin= t_date_fin[2]+"-"+t_date_fin[1]+"-"+t_date_fin[0];

            var url="{!! url('grand_livre_filtre/') !!}/"+select_jnx+"/"+date_dep+"/"+date_fin+"/"+view ; 
            location.href=url;
        }

    });
    </script>


    <script>
      $(function () {
        $("#_table").DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": true,
          "ordering": true,
          "info": true,
          "responsive": false,
          "autoWidth": false,
          "fixedHeader": true,
           oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }

            },
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",

            buttons: [
                { extend: 'copyHtml5', footer: true },
                { extend: 'excelHtml5', footer: true },
                { extend: 'csvHtml5', footer: true },
            ],
            "aaSorting": [
                [0,'desc']
            ],
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

      });
    </script>
@endsection