@extends('layouts.dash_pop')
@section('title_card',"")

@section('content')
        @if (Session::has('message'))
            <div class="alert alert-success">{{ Session::get('message') }}</div>
            <script>
                parent.location.reload();
                parent.jQuery.fancybox.close();
            </script>
        @else
            {{ html()->form('PUT', url('/ecriture_pop_add/' . $ecriture_base->id))->open() }}
                <input type="hidden" name="transaction" value="{!! $ecriture_base->transaction !!}">
                <div class="card card-info">
                    <div class="card-header">
                        <h3 class="card-title">{!! "Nouvelle écriture" !!}</h3>
                    </div>
                    @if ($errors)
                        @foreach ($errors->all() as $error)
                            <div class='bg-danger alert'>{!! $error !!}</div>
                        @endforeach
                    @endif


                    <div class='card-body'>
                        <div class="form-group row">
                            <div class='col-md-6'>
                                {!! html()->label('Compte','compte') !!}
                                {!! html()->select('compte')->options($comptes)->value('')->placeholder('A définir')->attributes(['class' => 'form-control'])  !!}
                            </div>

                            <div class='col-md-6'>
                                {!! html()->label('Compte Auxiliaire','compte_aux') !!}
                                {!! html()->select('compte_aux')->options($comptes_aux)->value('')->placeholder('A définir')->attributes(['class' => 'form-control'])  !!}
                            </div>
                        </div>


                        <div class="form-group row">
                            <div class='col-md-12'>
                                {!! html()->label('Désignation','designation') !!}
                                {!! html()->text('designation', '')->attributes(['class' => 'form-control']) !!}
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class='col-md-3'>
                                {!! html()->label('Débit','debit') !!}
                                {!! html()->text('debit', '')->attributes(['class' => 'form-control']) !!}
                            </div>
                        </div>

                        <div class="form-group row">
                            <div class='col-md-3'>
                                {!! html()->label('Crédit','credit') !!}
                                {!! html()->text('credit', '')->attributes(['class' => 'form-control']) !!}
                            </div>
                        </div>

                    </div>
                </div>

            <div class='form-group '>
                {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
            </div>
            {{ html()->form()->close() }}
        @endif
@endsection
