            <table id="_table" width="100%" class="table table-condensed table-bordered ">
                <thead>
                    <tr>
                        <th width='1%'>Transaction</th>
                        <th width='1%'>Date</th>
                        <th >Référence</th> 
                        <th width='1%'>journal</th> 
                        <th width='1%'>Débit</th>
                        <th width='1%'>Crédit</th>
                    </tr>
                </thead>
                <tbody>
                    @php 
                        $total_credit=0;
                        $total_debit=0; 
                    @endphp
                    @foreach ($transactions as $transaction)
                        @php
                            $equilibre=(abs($transaction->debit-$transaction->credit)==0);
                            $total_credit+=intVal($transaction->credit);
                            $total_debit+=intVal($transaction->debit);
                        @endphp
                        <tr style="">
                            <td align="center">
                                @if($user->hasRole("ADMINISTRATEUR") || $user->hasRole("COMPTABILITE") || $user->hasRole("CHEF_COMPTABILITE")|| $user->canPermissionName("GLI_VISU"))
                                <a href="{!! url('transaction/'.$transaction->transaction) !!}" >
                                    {!! str_pad($transaction->transaction,5,"0",STR_PAD_LEFT) !!}
                                </a>
                                @else
                                    {!! str_pad($transaction->transaction,5,"0",STR_PAD_LEFT) !!}
                                @endif
                            </td>
                            <td nowrap>{!! $transaction->date_doc !!}</td>
                            <td nowrap>
                                {!! $transaction->ref_doc !!}
                                @if(!$equilibre)
                                    <span class="right badge badge-danger">TRANSACTION PARIELLE (non équilibrée)</span>
                                @endif
                            </td>
                            <td nowrap>{!! $transaction->journal !!}</td>
                            <td align='right' nowrap style="{!! (!$equilibre)?'color:red':'' !!}">{!! $transaction->debit !!}</td>
                            <td align='right' nowrap style="{!! (!$equilibre)?'color:red':'' !!}">{!! $transaction->credit !!}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr style="background-color:lightgrey">
                        <th></th>
                        <th></th>
                        <th></th>
                        <th style="text-align:left">SOLDE:</th>
                        <th style="border-right:0px;text-align:right">{{ $total_credit-$total_debit }}</th>
                        <th></th>
                    </tr>
                </tfoot>

            </table>