@extends('layouts.dash')

@section('title','Grand Livre')
@if(isset($view) && ($view=='transactions'))
    @section('title_card',"Grand Livre - Vue par transaction")
@else
    @section('title_card',"Grand Livre - Vue par écritures")
@endif
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('success'))
            <div class="alert alert-success">{!! \Session::get('success') !!}</div>
        @endif  
        
        <div class="card-header">

            <form class="form-inline">
                <div class='form-group'>
                    {!! html()->label('Date de début','date_debut') !!}&nbsp;&nbsp;
                    <div class='input-group date' id='datepicker_date_debut'>
                    {!! html()->text('date_debut', isset($date_deb)?$date_deb:'01/01/'.date('Y'))
                        ->attributes(['id'=>'date_debut','size'=>'10','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='form-group ml-4' style=''>
                    {!! html()->label('Date de fin','date_fin') !!}&nbsp;&nbsp;
                    <div class='input-group date' id='datepicker_date_fin'>
                    {!! html()->text('date_fin', isset($date_fin)?$date_fin:'31/12/'.date('Y'))
                        ->attributes(['id'=>'date_fin','size'=>'10','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='col-md-2 p-4' style="margin-top:5px" >
                    <a id='btn_filtre' class="btn btn-primary"  href="#" ><i class="fas fa-search"></i>&nbsp;Rechercher</a>
                </div>
            </form>


            <form class="form-inline">
                <div class="form-group col-md-5">
                    {!! html()->label('Journal','jnx') !!}
                    {!! html()->select('jnx')->options($liste_journaux+["ALL"=>"Tous"])
                        ->value(isset($jnx)?$jnx:"")
                        ->placeholder('Choisir un journal')
                        ->attributes(['id'=>'jnx','class' => 'form-control'])  !!}
                </div>


                <div class='col-md-2 p-4' style="margin-top:5px" >
                    <a class="btn btn-{!! ($view=='transactions')?'info':'default' !!}" href="#" onclick="valide('transactions')">
                        <i title="Transactions" class="fas fa-align-left"></i>
                    </a>
                    <a class="btn btn-{!! ($view=='ecritures')?'info':'default' !!}" href="#" onclick="valide('ecritures')">
                        <i title="Ecritures" class="fas fa-align-justify"></i>
                    </a>
                </div>
            </form>
        </div>

        <div class="card-body">
            @if($user->hasRole("ADMINISTRATEUR") || $user->hasRole("COMPTABILITE") || $user->hasRole("CHEF_COMPTABILITE"))
                <div class='col-md-4'>
                    <a title="Nouvelle transaction" href="{!! url('grand_livre/create') !!}" class="btn  btn-success"><i class="fas fa-add"></i>&nbsp;Nouvelle transaction</a> 
                </div>
            @endif 

            @if(isset($view) && ($view=='transactions'))
                @include("comptabilite.grandlivre.liste_transactions")
            @else
                @include("comptabilite.grandlivre.liste_ecritures")
            @endif
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable_btn")

    <script type="text/javascript">
    $(function () {
        $('#datepicker_date_debut').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });

        $('#datepicker_date_fin').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });

        $('#sel_compte').change( function() {
            filtre();
        });

        $('#btn_filtre').click( function() {
            filtre();
        });

        function filtre() {
            var select_jnx = $('#jnx').val();
            if(select_jnx=="") select_jnx=0;
            var date_dep=$('#date_debut').val();
            var date_fin=$('#date_fin').val();
            var t_date_dep = date_dep.split('/');
            date_dep= t_date_dep[2]+"-"+t_date_dep[1]+"-"+t_date_dep[0];
            var t_date_fin = date_fin.split('/');
            date_fin= t_date_fin[2]+"-"+t_date_fin[1]+"-"+t_date_fin[0];

            var url="{!! url('grand_livre_filtre/') !!}/"+select_jnx+"/"+date_dep+"/"+date_fin+"/"+view ; 
            location.href=url;
        }

    });
    </script>
@endsection