@extends('layouts.dash')

@section('title','Grand Livre')
@section('title_card',"Grand Livre")
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif
        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-4'>
                    {!! Form::label('jnx', 'Journal') !!}
                    {!! Form::select('jnx',
                            $liste_journaux+["ALL"=>"Tous"],isset($jnx)?$jnx:"",
                                ['placeholder'=>'Choisissez un journal','id'=>'jnx','class' => 'form-control']) !!} 
                </div>

                <div class='col-md-2'>
                    {!! Form::label('date_debut', 'Date de début') !!}
                    <div class='input-group date' id='datepicker_date_debut'>
                    {!! Form::text('date_debut',isset($date_debut)?$date_debut:'01/01/'.date('Y'), 
                            ['id'=>'date_debut','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='col-md-2'>
                    {!! Form::label('date_fin', 'Date de fin') !!}
                    <div class='input-group date' id='datepicker_date_fin'>
                    {!! Form::text('date_fin',isset($date_fin)?$date_fin:'31/12/'.date('Y'), 
                            ['id'=>'date_fin','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='col-md-2 p-4' style="margin-top:5px" >
                    <a class="btn btn-primary"  href="#" onclick="valide()">Rechercher</a>
                </div>
            </div>

            <script>
                function valide() {
                    var select_jnx = [...document.getElementById('jnx').selectedOptions].map(option => option.value);
                    if(select_jnx=="") select_jnx=0;
                    var date_dep=document.getElementById('date_debut').value;
                    var date_fin=document.getElementById('date_fin').value;
                    var t_date_dep = date_dep.split('/');
                    date_dep= t_date_dep[2]+"-"+t_date_dep[1]+"-"+t_date_dep[0];
                    var t_date_fin = date_fin.split('/');
                    
                    date_fin= t_date_fin[2]+"-"+t_date_fin[1]+"-"+t_date_fin[0];
                    var url="{!! url('grand_livre_filtre/') !!}/"+select_jnx+"/"+date_dep+"/"+date_fin ; 
                    location.href=url;
                }
            </script>
        </div>

        <div class="card-body">
                @if($user->hasRole("ADMINISTRATEUR") || $user->hasRole("COMPTABILITE") || $user->hasRole("CHEF_COMPTABILITE"))
                <a title="Nouvelle transaction" href="{!! url('grand_livre/create') !!}" class="btn  btn-sm btn-success">
                Nouvelle transaction</a> 
            @endif 
            <table id="_table" width="100%" class="table table-condensed table-bordered ">
                <thead>
                    <tr>
                        <th width='1%'>Transaction</th>
                        <th width='1%'>Ref</th>
                        <th width='1%'>Date</th>
                        <th width='1%'>Piece</th> 
                        <th width='1%'>journal</th> 
                        <th width='1%'>Code Compte</th> 
                        <th>Compte</th> 
                        <th width='1%'>Code Compte Aux.</th>
                        <th>Nom Compte AUx.</th>
                        <th>Designation</th>
                        <th width='1%'>Débit</th>
                        <th width='1%'>Crédit</th>
                        <!-- <th width='1%'>Lettrage</th> -->
                        <!-- <th width='1%'>Verrou</th> -->
                        @if($user->hasRole("ADMINISTRATEUR") || $user->hasRole("COMPTABILITE") || $user->hasRole("CHEF_COMPTABILITE")|| $user->canPermissionName("GLI_MAJ"))
                            <th width='1px'>

                            </th>
                        @endif 
                    </tr>
                </thead>
                <tbody>
                    @foreach ($grandlivre as $ligneGL)
                    <tr style="">
                        <td align="center">
                            @if($user->hasRole("ADMINISTRATEUR") || $user->hasRole("COMPTABILITE") || $user->hasRole("CHEF_COMPTABILITE")|| $user->canPermissionName("GLI_VISU"))
                            <a href="{!! url('grand_livre/'.$ligneGL->id) !!}" >
                                {!! $ligneGL->IdTransaction !!}</span>
                            </a>
                            @else
                                {!! $ligneGL->IdTransaction !!}
                            @endif
                        </td>
                        <td nowrap>{!! $ligneGL->ref_doc !!}</td>
                        <td nowrap>{!! $ligneGL->date_doc !!}</td>
                        <td nowrap align="center">
                            @if(strlen($ligneGL->type)>=7)
                                @if(substr($ligneGL->type,0,7)=="SALAIRE")
                                   <a href="{!! url('salaire_fiche_edition'.'/'.$ligneGL->piece) !!}" target="_blank">
                                        {!! "Bulletin N° ".str_pad($ligneGL->piece,"0",4,STR_PAD_RIGHT) !!}</a>
                                @endif
                                @if(substr($ligneGL->type,0,7)=="FACTURE")
                                    <a href="{!! url('achats'.'/'.$ligneGL->piece) !!}" target="_blank">
                                        {!! "Achat N° ".str_pad($ligneGL->piece,"0",4,STR_PAD_RIGHT) !!}</a>
                                @endif
                            @endif
                        </td>
                        <td nowrap>{!! $ligneGL->journal !!}</td>
                        <td nowrap>{!! $ligneGL->compte !!}</td>
                        <td >{!! $ligneGL->CompteLabel !!}</td>
                        <td nowrap>{!! $ligneGL->compte_aux !!}</td>
                        <td >{!! $ligneGL->compte_aux_label !!}</td>
                        <td >{!! $ligneGL->designation !!}</td>
                        <td align='right' nowrap>{!! $ligneGL->debit !!}</td>
                        <td align='right' nowrap>{!! $ligneGL->credit !!}</td>
                        <!-- <td nowrap>{!! $ligneGL->lettrage_code !!}</td> -->
                        <!-- <td nowrap>{!! $ligneGL->verrou !!}</td> -->  
                        @if($user->hasRole("ADMINISTRATEUR") || $user->hasRole("COMPTABILITE") || $user->hasRole("CHEF_COMPTABILITE")|| $user->canPermissionName("GLI_MAJ"))
                            <td nowrap>
                            @if($ligneGL->verrou!=1)
                                    {!! Form::open(['url' => url('grand_livre/' . $ligneGL->id), 'method' => 'DELETE']) !!}                                
                                    {{ csrf_field() }}
                                        @if($ligneGL->IsSupprimable) 
                                            <button class="btn btn-danger btn-sm"><span class='ti-trash'></span></button>
                                        @endif
                                    {!! Form::close() !!}
                            @endif
                            </td>
                        @endif
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable_btn")

    <script type="text/javascript">
    $(function () {
        $('#datepicker_date_debut').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });

        $('#datepicker_date_fin').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });
    });
    </script>
@endsection