@extends('layouts.dash')
{!! $with_navbar=false !!}
@section('title') Transaction @stop
@section('title_card',"Nouvelle transaction")


@section('content')

    {{ html()->form('POST', url('/grand_livre'))->attributes(["class"=>""])->open() }} 
    <div class="card">
            @if ($errors)
                @foreach ($errors->all() as $error)
                    <div class='bg-danger alert'>{!! $error !!}</div>
                @endforeach
            @endif
        <div class="card-header bg-info">
            Nouvelle Transaction
        </div>
        <div class="card-body">
            <div class="form-group row callout callout-info">
                <div class='col-md-3'>
                    <label for="date_doc" class="control-label">Date Pièce</label>
                    <div class='input-group date' id='datepicker_date_doc'>
                        {!! html()->text('date_doc', date('d/m/Y'))->attributes(['id'=>'date_doc','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>

                <div class='col-md-4'>
                    <label for="journal" class="control-label">Journal</label>
                    {!! html()->select('journal')->options($liste_journaux)
                            ->value("")->placeholder('A définir')->attributes(['class' => 'form-control','width' => '100%'])  !!}
                </div>

                <div class='col-md-5'>
                    <label for="ref_doc" class="control-label">Référence/Pièce</label>
                    {!! html()->text('ref_doc', "")->attributes(['class' => 'form-control']) !!}
                </div>
            </div>

            <div class='form-group'>
                <div class="col-md-12">
                    {!! html()->button('Créer la transaction')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
                    <a class="btn btn-warning"  href="{!! url('grand_livre') !!}">Annuler</a>
                </div>
            </div>   
        </div>
    </div>
    {{ html()->form()->close() }}
@endsection


@section('scripts')
    <script type="text/javascript">
    $(function () {
        $('#datepicker_date_doc').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });
    });
    </script>
@endsection