@extends('layouts.dash')
{!! $with_navbar=false !!}
@section('title') Transaction @stop
@section('title_card',"Consulter une Transaction")


@section('content')
<div class="card">
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif

        @if (Session::has('message'))
            <div class="alert alert-success">{!! Session::get('message') !!}</div>
        @endif


        <div class="col-lg-max col-lg-offset-1 container-fluid"> 
            {{ html()->modelForm($grand_livre_ligne)->attributes(['grand_livre_ligne' => 'form', 'url' => '/grand_livre/'.$grand_livre_ligne->id, 'class' => 'form-horizontal', 'method' => 'PUT'])->open() }}
                <input type="hidden" name="id_ecriture_base" value="{!! $grand_livre_ligne->id !!}">

                @include("comptabilite.grandlivre.content")

                <div class='form-group row'>
                    <div class="col-md-12">
                        @if($user->hasRole("ADMINISTRATEUR") || $user->can("GLI_MAJ"))
                        <a href="{!! url('grand_livre/'.$grand_livre_ligne->id.'/edit') !!}" 
                            class="btn btn-info " style="margin-right: 3px;">
                            Modifier
                        </a>
                        @endif
                        <a class="btn btn-warning"  href="{!! url('grand_livre') !!}">Retour</a>
                    </div>
                </div>
            {{ html()->closeModelForm() }}
        </div>
</div>
@endsection

