@extends('layouts.dash')
{!! $with_navbar=false !!}
@section('title') Transaction @stop
@section('title_card',"")


@section('content')
<div class="card">
        <div class="card-header bg-info">
            <h3>Transaction - consultation ({{ $grand_livre_ligne->IdTransaction }})</h3>
        </div>
        <div class="card-body">
                {{ html()->modelForm($grand_livre_ligne, 'PUT', url('/grand_livre/' . $grand_livre_ligne->id))->open() }}
                    <input type="hidden" name="id_ecriture_base" value="{!! $grand_livre_ligne->id !!}">
                    <input type="hidden" name="num_ligne_max" id="num_ligne_max" value="">
                    <input type="hidden" name="all_data" id="all_data" value="">
                    @if(Session::has('transacstore'))
                        {!! html()->hidden('transacstore', Session::get('transacstore'))->attributes(['id'=>'transacstore']) !!}
                    @endif

                    <div class="col-md-12">
                        <div class="form-group row callout callout-info">
                            <div class='col-md-2'>
                                {!! html()->label('Pièce','date_doc') !!}
                                {!! html()->text('created_at', $grand_livre_ligne->date_doc)->attributes(['style'=>'text-align:center','disabled','class' => 'form-control']) !!}
                            </div>
                            <div class='col-md-3'>
                                {!! html()->label('journal','journal') !!}
                                {!! html()->text('journal', $grand_livre_ligne->journal)->attributes(['disabled','style'=>'text-align:center','class' => 'form-control']) !!}
                            </div>
                            <div class='col-md-4'>
                                {!! html()->label('Référence','ref_doc') !!}
                                {!! html()->text('ref_doc', $grand_livre_ligne->ref_doc)->attributes([(($mode=='show')?'disabled':''),'class' => 'form-control']) !!}
                            </div>
                            <div class='col-md-2'>
                                {!! html()->label('Date&nbsp;de&nbsp;création','created_at') !!}
                                {!! html()->text('created_at', $grand_livre_ligne->DateCreation)->attributes(['disabled','style'=>'text-align:center','class' => 'form-control']) !!}
                            </div>
                        </div>
                    </div>


                    <div class="col-md-12">
                        <div class="form-group row">
                            <div class='col-md-12'>
                                <label for="liste" class="col-sm-3 control-label">Liste des mouvements</label>
                            </div>
                            <div class='col-md-12'>


                                <table id="table_e" class="table table-striped  table-condensed table-bordered table-hover" name="table_e" width="100%">
                                    <thead style="background-color:lightgrey">
                                        <tr style="">
                                            <th>Compte</th>
                                            <th>Compte Auxiliaire</th>
                                            <th width="1px">DatePièce</th>
                                            <th >Libellé Opération</th>
                                            <th width="1px">Débit</th>
                                            <th width="1px">Crédit</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        @php $total_credit=0;$total_debit=0; @endphp
                                        @foreach($ecritures as $ecriture) 
                                            @php
                                                $total_credit+=$ecriture->credit;
                                                $total_debit+=$ecriture->debit;
                                            @endphp
                                            <tr style="">
                                                <td align=''>{{ $ecriture->compte." - ".$ecriture->compte_label }}</td>
                                                <td align=''>{{ $ecriture->compte_aux." - ".$ecriture->compte_aux_label }}</td>
                                                <td align=''>{{ $ecriture->date_ref }}</td>
                                                <td align=''>{{ $ecriture->designation }}</td>
                                                <td align='right' class="text-danger "><b>{{ $ecriture->debit }}</b></td>
                                                <td align='right' class="text-green "><b>{{ $ecriture->credit }}</b></td>
                                            </tr>

                                        @endforeach
                                    </tbody>

                                    <tfoot style="background-color:lightgrey">
                                        <tr>
                                            <td colspan="4">TOTAL</td>
                                            <td align='right' class="text-danger ">{{ $total_credit }}</td>
                                            <td align='right' class="text-green ">{{ $total_debit }}</td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </td>

                        </div>
                    </div>


                    <div class='form-group row'>
                        <div class="col-md-12">
                            @if( (($total_credit==$total_debit)&&($total_debit==0)) || ($total_credit!=$total_debit))
                                @if($user->hasRole("ADMINISTRATEUR") || $user->can("GLI_MAJ"))
                                <a href="{!! url('grand_livre/'.$grand_livre_ligne->id.'/edit') !!}" 
                                    class="btn btn-info " style="margin-right: 3px;">
                                    Modifier
                                </a>
                                @endif
                            @endif
                            <a class="btn btn-warning"  href="{!! url('grand_livre') !!}">Retour</a>
                        </div>
                    </div>
                {{ html()->closeModelForm() }}
        </div>
</div>
@endsection


@section('scripts0')
    
@endsection


@section('scripts')

<script>
  $(function () {
    $("#table_e").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": false,
      "responsive": false, 
      "autoWidth": false,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
        //"buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv", 
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>

@endsection