@extends('layouts.dash')

@section('title') Journaux @stop
@section('title_card') Journaux @stop
@section('subtitle_card',"Liste complète")
@section('content')


    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif
        <div class="card-body">

            <div class='col-md-12 form-group row'>
                <a href="{!! url('journaux/create') !!}" class="float-right btn  btn-sm btn-success">Nouveau Journal</a>
            </div>

            <div class='col-lg-max form-group row'>
                <table id="_table" width="100%" class="table table-bordered">
                    <thead>
                        <tr>
                            <th width='1px'>Nom Court</th>
                            <th >nom</th>
                            <th >Nb Ecritures</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($journaux as $journal)
                        <tr class="">
                            <td nowrap >
                                <a href="{!! url('journaux/'.$journal->id) !!}" >{!! $journal->nom_court !!}</a>
                            </td>
                            <td nowrap >{!! $journal->nom !!}</td>
                            <td nowrap align='center' >{!! $journal->NbEcritures !!}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection


@section('scripts')
<script>
  $(function () {
    $("#_table").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": false,
      "responsive": true, 
      "autoWidth": false,
      iDisplayLength:20,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }
        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-12'B>>",

        "buttons": ["copy", "excel", "colvis"], //"print", "pdf", "csv", 
        "aaSorting": [
            [0,'asc']
        ],
        "columnDefs": [

        ]
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
@endsection