@extends('layouts.dash')
{!! $with_navbar=false !!}
@section('title') Journal @stop
@section('title_card',"Consultation d'une fiche Journal")
@section('content')
<div class="card">
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="col-lg-max col-lg-offset-1 container-fluid"> 
            {{ html()->modelForm($journal)->attributes(['journaux' => 'form', 'url' => '/journaux/'.$journal->id, 'class' => 'form-horizontal', 'method' => 'PUT'])->open() }}

                @include("comptabilite.journaux.content")

            {{ html()->closeModelForm() }}
            @if(($user->hasRole("ADMINISTRATEUR") || $user->can("PLA_SUP"))  && ($journal->NbEcritures==0))   
                {{ html()->form('DELETE', url('journaux/' . $journal->id))->open() }}                   
                    {{ csrf_field() }}
                    <button class="btn btn-danger">Supprimer</button>
                {{ html()->closeModelForm() }}
            @endif
        </div>
</div>
@endsection