

<div class="form-group row">
    <div class="col-md-3">
        {!! html()->label('COMPTE','compte') !!}
        {!! html()->text('compte', null)->attributes([($mode=="show"?'disabled':''),'placeholder' => 'numéro de compte', 'class' => 'form-control']) !!}
    </div>
</div>


<div class="form-group row">
    <div class="col-md-6">
        {!! html()->label('Désignation','libelle') !!}
        {!! html()->text('libelle', null)->attributes([($mode=="show"?'disabled':''),'placeholder' => 'Désignation du compte', 'class' => 'form-control']) !!}
    </div>
</div>

<div class="form-group row">
    <div class='col-md-3'>
        {!! html()->label('Catégorie pour Bilan','categ_bilan') !!}
        {!! html()->select('categ_bilan',["A"=>"Actif","P"=>"Passif"],isset($plan_comptable->categ_bilan)?$plan_comptable->categ_bilan:"")
                ->placeholder("Choisissez une catégorie")
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']) !!} 
    </div>
</div>

<div class="form-group row">
    <div class="col-md-3">
        {!! html()->label('Montant prévisionnel','previsionnel') !!}
        {!! html()->number('previsionnel', null)->attributes([($mode=="show"?'disabled':''),'placeholder' => '', 'class' => 'form-control']) !!}
    </div>
</div>



<div class="form-group">
    <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
      {!! html()->checkbox('titre', '1', isset($plan_comptable->titre)?$plan_comptable->titre:0)
        ->attributes([($mode=="show"?'disabled':''),'id' => 'box_titre', 'class' => 'custom-control-input']) !!}
      <label class="custom-control-label" for="box_titre">Compte (et non sous-compte)</label>
    </div>
</div>

<div class="form-group">
    <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
      {!! html()->checkbox('actif', '1', isset($plan_comptable->actif)?$plan_comptable->actif:1)
        ->attributes([($mode=="show"?'disabled':''),'id' => 'box_actif', 'class' => 'custom-control-input']) !!}
      <label class="custom-control-label" for="box_actif">Compte actif</label>
    </div>
</div>


<div class='form-group row'>
    <div class="col-md-12">
        @if($mode!="show")
            {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
        @else
            @if($user->hasRole("ADMINISTRATEUR") || $user->can("PLA_SUP"))     
                {{ html()->form('DELETE', url('/plan_comptable/' . $plan_comptable->id))->open() }}                       
                    {{ csrf_field() }}
                    <button class="btn btn-danger">Supprimer</button>
                {{ html()->closeModelForm() }}
            @endif
            @if($user->hasRole("ADMINISTRATEUR") || $user->can("PLA_MAJ"))
                <a class="btn btn-primary"  href="{!! url('plan_comptable/'.$plan_comptable->id.'/edit') !!}">Modifier</a>
            @endif
        @endif

        <a class="btn btn-warning"  href="{!! url('plan_comptable') !!}">Retour</a>
    </div>
</div>