@extends('layouts.dash')

@section('title') Plan comptable général @stop
@section('title_card') Plan comptable général @stop
@section('subtitle_card',"Liste complète")

@section('content')
    <div class="card">
        <div class="card-header">
            @if (Session::has('message'))
                <div class="alert alert-warning">{!! Session::get('message') !!}</div>
            @endif
        </div>

        <div class="card-body">
            <div class='form-group row'>
                <div class="col-md-12 ">
                    <a href="{!! url('plan_comptable/create') !!}" class="float-right btn  btn-sm btn-success">Nouveau Compte</a>
                </div>
            </div>

            <div class='form-group row'>
                <div class="col-md-12">
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>CompteTri</th>
                                <th width='1%'>Compte</th>
                                <th>Designation</th>
                                <th width='1%'>Prévisionnel</th>
                                <th width='1%'>Categorie</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($plancomptables as $plancomptable)
                            <tr class="{!! ($plancomptable->titre==1)?'p_titre':'' !!}">
                                <td nowrap>{!! str_pad($plancomptable->compte,7,'0',STR_PAD_RIGHT) !!}</td>
                                <td nowrap >
                                    <a href="{!! url('plan_comptable/'.$plancomptable->id) !!}" >
                                        {!! $plancomptable->compte !!}
                                    </a>
                                </td>
                                <td>{!! $plancomptable->libelle !!}</td>
                                <td nowrap align="right" style='font-style:italic'>{!! $plancomptable->previsionnel !!}</td>
                                <td nowrap>{!! $plancomptable->categ_bilan !!}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('scripts')
<script>
  $(function () {
    $("#_table").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": false,
      "responsive": true, 
      "autoWidth": true,
      iDisplayLength:20,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }
        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",

        "buttons": ["copy", "excel", "colvis"], //"print", "pdf", "csv", 
        "aaSorting": [
            [0,'asc']
        ],
        "columnDefs": [
            { "targets": [ 4], "searchable": false},
            { "targets": [ 0], "visible": false},
            { "targets": [ 1-4], "orderable": false},
        ]
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
@endsection