@extends('layouts.dash')
@section('title') Historique @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header">
            <h3 style="margin-top:0px;">Historique des modifications<h3>
        </div>
        
            <div class="card-body">
                @if($mode=='S')
                    <h4>Historique des modifications : {!! $salaire->BeneficiaireNom !!}<br/>{!! $salaire->EmployeurNom !!}</h4>
                @endif
                <table id="_table" class="table  table-striped">
                    <thead>
                        <tr>
                            <th rowspan="2" width='1%'>Date</th>
                            <th rowspan="2" width='1%'>Login</th>
                            @if($mode!='S')
                                <th rowspan="2" width='1%'>Beneficiaire</th>
                                <th rowspan="2" width='1%'>Employeur</th>
                            @endif
                            <th >Modifications</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($t_res as $date=>$value)
                            <tr>
                                <td nowrap>{!! $value["date"] !!}</td>
                                <td >{!! $value["login"] !!}</td>

                                @if($mode!='S')
                                <td >{!! $value["nom_beneficiaire"] !!}</td>
                                <td >{!! $value["nom_employeur"] !!}</td>
                                @endif
                                <td nowrap >{!! $value["value"] !!}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    </div>
@endsection

@section('scripts')
<script>
  $(function () {
    $("#_table").DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "responsive": false,
      "autoWidth": false,
      "fixedHeader": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",

        "buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv",
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
@endsection