@extends('layouts.dash_pop')
@section('title')  @stop
@section('title_card',"Historique des modification")
@section('subtitle_card',"Liste")

@section('content')
    <div class="card ">
        <div class="card-header bg-info">
            <h3 style="margin-top:0px;">{!! $employeur->nom !!}<h3>
        </div>
        <div class="card-body">
            <table id="_table" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th width='1%'>Date</th>
                        <th width='1%'>Login</th>
                        @if(!$employeur)
                            <th>Employeur</th>
                        @endif
                        <th>Beneficiaire</th>
                        <th>Modifications</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($t_res as $tt_res)
                        @foreach ($tt_res as $value)
                        <tr>
                            <td nowrap>{!! $value["date"] !!}</td>
                            <td nowrap>{!! $value["login"] !!}</td>
                            @if(!$employeur)
                                <td >{!! $value["nom_employeur"] !!}</td>
                            @endif
                            <td >{!! $value["nom_beneficiaire"] !!}</td>
                            <td >{!! $value["value"] !!}</td>
                        </tr>
                        @endforeach
                    @endforeach
                </tbody>

            </table>
        </div>
    </div>
@endsection

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts0')


    <script>



    $(document).ready(function() {
        $.fn.dataTable.moment('D/M/YYYY');

        var table =$('#_table').dataTable( {
            bAutoWidth: false,
            bPaginate: false,
            bInfo: false,
            bFilter: true,
            deferRender:    true,
            scrollCollapse: false,
            scroller:       false,

            iDisplayLength:15,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher ",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                    }
                }

                },
                //"dom": '<"top"fBl>rt<"bottom"ip><"clear">',
                dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                buttons: [
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} },
                ],


            } );


    } );
    </script>

@endsection
