@extends('layouts.dash'.($frame?'_pop':''))
@section('title') Imputation @stop


@section('content')
    @if (Session::has('message'))
        <div class="alert alert-success">{{ Session::get('message') }}</div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    @else

        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="card card-info">
            <div class="card-header">
                <h2>Imputation : <small>{{ str_pad($imputation->id, 5, "0", STR_PAD_LEFT) }}</small></h2>
            </div>
            <div class='card-body'>
                {{ html()->modelForm($imputation, 'PUT', url('imputations/' . $imputation->id))->open() }}
                    <input type="hidden" name="mode_frame" id="mode_frame" value="{!! $frame !!}">
                    @include("mandatements.imputations.content")
                {{ html()->closeModelForm() }}
            </div>
        </div>
    @endif
@stop


