@extends('layouts.dash')

@section('title') Imputations @stop
@section('title_card') Imputations @stop
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-3'>
                {!! html()->label('Années :','annes') !!}
                {!! html()->select('exercice')->options($exercices)
                    ->value($exercice)
                    ->placeholder('Choisir un exercice')
                    ->attributes(['class' => 'form-control','id' => 'exercice_id'])  !!}
                </div>
            </div>
        </div>

        <div class="card-body">
            <table id="_table" style="background-color:white"
                class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th width='1px' nowrap>Id</th>
                        <th width='1px' nowrap>N°Compte</th>
                        <th>Désignation</th>
                        <th width='1px'>Montant</th>
                        <th width='1px'>Type</th>
                        <th width='1px'>Id&nbsp;Mandat</th>
                        <th width='1px'>Statut&nbsp;Mandat</th>
                        <th width='1px'>Transfert&nbsp;Mandat</th>
                        <th>Observations</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($imputations as $imputation)
                    <?php
                        $imputations=App\Models\Imputation::find($imputation->idmandat);
                    ?>
                    <tr class="clickable-row" data-href="{!! url('imputations/'.$imputation->id) !!}">
                        <td align="center">
                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('imputations/'.$imputation->id)!!}"
                                    class="" style="margin-right: 3px;">
                            @endif
                            {!! str_pad($imputation->id,5,'0',STR_PAD_LEFT) !!}
                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                </a>
                            @endif
                        </td>
                        <td align="center">{!! $imputation->cpt_imp !!}</td>
                        <td>{!! $imputation->designation !!}</td>
                        <td align="right">{!! $imputation->montant !!}</td>
                        <td align="center">{!! $imputation->type_imp !!}</td>
                        <td align="center">{!! $imputation->idmandat !!}</td>
                        <td align="center">{!! $imputation->MandatStatut !!}</td>
                        <td align="center">{!! $imputation->DateTransfert !!}</td>
                        <td>{!! $imputation->obs !!}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>


        @if($user->can("IMP_AJO") || $user->HasRole("ADMINISTRATEUR"))
            <div class="card-footer">
                <h4><a href="{!! url('imputations/create') !!}"
                    class="btn btn-success">Ajouter une Imputation</a></h4>
            </div>
        @endif
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable_btn")
    <script>
        $(document).ready(function() {
            $('#exercice_id').on('change', function() {
                location.href="{!! url('/mandatements/imputations_annee/') !!}/"
                    +$('#exercice_id').val();
            });
        });
    </script>
    @if($user->can("IMP_VISU") || $user->HasRole("ADMINISTRATEUR"))
        <script>
        jQuery(document).ready(function($) {
            $(".clickable-row").click(function() {
                window.document.location = $(this).data("href");
            });
        });
        </script>
    @endif

@endsection
