@extends('layouts.dash')
@section('title') Mandat @stop


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-info">
        <div class="card-header">
            <h2>Nouveau Mandat</small></h2>
        </div>
        <div class='card-body'>
            {{ html()->form('POST', url('mandats'))->open() }}
                @include("mandatements.mandats.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop



@section('scripts0')
    <script type="text/javascript">
        $(function () {
            $('#datepicker_date_sai').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });

            $('#datepicker_date_valid').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });

            $('#datepicker_date_valid_dir').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });
        });
    </script>
@stop

