@extends('layouts.dash')
@section('title') Mandat @stop

@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-info">
        <div class="card-header">
            <h2>Mandat <small>Mise à jour</small></h2>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($mandat, 'PUT', url('/mandats/' . $mandat->id))->attributes(['id'=>'form'])->open() }}
                <input type="hidden" name="refresh" id="refresh" value="{!! false !!}">
                <input type="hidden" name="delete_imputation" id="delete_imputation" value="0">
                <input type="hidden" name="delete_creancier" id="delete_creancier" value="0">
                <input type="hidden" name="reload_form" id="reload_form" value="false">
                @include("mandatements.mandats.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop


@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    <script type="text/javascript">
        $(function () {
            $('#datepicker_date_sai').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });

            $('#datepicker_date_valid').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });

            $('#datepicker_date_valid_dir').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });
        });
    </script>

    <script>
        //Rechargement sur la page en cours
        $(document).ready(function() {
            $("#save_reload").click(function() {savereload();})
            function savereload() {
                $("#reload_form").val(true);
                $('#form').submit();
            }
        } );
    </script>

    <script type="text/javascript">
        $(document).ready(function() {
            $(".box_imput").fancybox({
                width:'70%',
                autoDimensions:false,
                fitToView   : false,
                autoSize    : false,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
                afterLoad: function () {
                    eTarget=$(this.element).attr("id");
                },
                afterClose: function () {
                    if (eTarget!="btn_visu_imputation") {
                        $("#refresh").val(true);
                        //$("#form").submit();
                    }
                    return;
                }
            });
            $(".box_creancier").fancybox({
                width:'70%',
                autoDimensions:false,
                fitToView   : false,
                autoSize    : false,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
                afterLoad: function () {
                    eTarget=$(this.element).attr("id");
                },
                afterClose: function () {
                    if (eTarget!="btn_visu_creancier") {
                        $("#refresh").val(true);
                        //$("#form").submit();
                    }
                    return;
                }
            });
        });

        function delete_imputation(id) {
            if(!confirm("Voulez-vous vraiment supprimer cette imputation ?")) return false;
            $('#delete_imputation').val(id);
            $("#refresh").val(true);
            $('#form').submit();
        }

        function delete_creancier(id)  {
            if(!confirm("Voulez-vous vraiment supprimer ce créancier ?")) return false;
            $('#delete_creancier').val(id);
            $("#refresh").val(true);
            $('#form').submit();
        }

        
    </script>
@stop
