@extends('layouts.master')
 
@section('title') Mise à jour d'un Mandat @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-banque'></i> Mise à jour d'un Mandat</h1>
 
    {!! Form::model($mandat, ['mandat' => 'form'
        , 'url' => '/mandatements/mandats/' . $mandat->id, 'method' => 'PUT', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">
        <div class="form-group">
            <div class="col-md-2">
                <div class="has-success has-feedback">
                    <div class="input-group">
                        <span class="input-group-addon">N°</span>
                        <input readonly="readonly" type="text" class="form-control" name="id" id="id" 
                        value='{!! str_pad($mandat->id, 6, "0", STR_PAD_LEFT) !!}' />
                    </div>
               </div>
           </div>
        </div>

        <div class="form-group">
            <div class="col-md-1">
                {!! Form::label('exercice', 'Exercice') !!}
                {!! Form::text('exercice', $mandat->exercice, ['placeholder' => "Exercice", 'class' => 'form-control']) !!}
            </div>

            <div class="col-md-3">
                {!! Form::label('date_sai', 'Date') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_date_sai'>
                        {!! Form::text('date_sai', $mandat->date_sai, ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date_sai').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                {!! Form::label('statut_mdt', 'Statut') !!}
                {!! 
                Form::select(
                    'statut_mdt',
                    ['ANN'=>'Annulé','ENC' => 'En-cours','REJ' => 'Rejeté','VAL' => 'Validé'],
                    $mandat->statut_mdt,
                    ['class' => 'selectpicker','data-width' => "100%"]
                ) 
                    
                !!}
            </div>
        </div>

        <div class='form-group'>
            <div class="col-md-6">
            {!! Form::label('observation', 'Observations') !!}
            {!! Form::textarea('observation', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'2']) !!}
            </div>
        </div>


        <div class="col-md-8 bg-success" >  
            <div class='form-group'  style="padding-top:0px">
                <div class="col-md-3">
                    <legend style="margin:0px"><b><i> Directeur</i></b></legend>
                    {!! Form::label('date_valid_dir', 'Date') !!}
                    <div class="input-group">
                        <div class='input-group date' id='datepicker_date_valid_dir'>
                            {!! Form::text('date_valid_dir', $mandat->date_valid_dir, ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_date_valid_dir').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    {!! Form::label('observation_dir', 'Observations') !!}
                    {!! Form::textarea('observation_dir', null, ['placeholder' => 'Observations du Directeur', 'class' => 'form-control', 'rows'=>'3']) !!}
                </div>

            </div>
        </div>


        <div class="col-md-8 bg-info" >
            <div class='form-group'  style="padding-top:0px">
                <div class="col-md-3">
                    <legend style="margin:0px"><b><i> Comptable</b></i></legend>
                    {!! Form::label('date_valid', 'Date') !!}
                    <div class="input-group">
                        <div class='input-group date' id='datepicker_date_valid'>
                            {!! Form::text('date_valid', $mandat->date_valid, ['alt' => 'Date de validation comptable', 'class' => 'form-control']) !!}
                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_date_valid').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    {!! Form::label('observation_val', 'Observations') !!}
                    {!! Form::textarea('observation_val', null, ['placeholder' => 'Observations du Directeur', 'class' => 'form-control', 'rows'=>'3']) !!}
                </div>

            </div>
        </div>


        <div class="row">
            <div class="col-xs-8 " >
                <h4>Imputations</h4>
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th width='20%'>Compte</th>
                                <th >Désignation</th>
                                <th width='5%'>Montant</th>
                                <th width='5%'>Type</th>
                                <th >Observations</th>
                                <th  width='1%'>
                                    @if($user->can("IMP_AJO") || $user->HasRole("ADMINISTRATEUR"))
                                        <a href="{!! url('imputation_create_avec_mandat/'.$mandat->id) !!}" 
                                        id='btn_ajout_imputation' 
                                        class="box_imput fancybox.iframe btn btn-success" 
                                        target="_blank">Ajouter une Imputation</a>
                                    @endif
                                </th>
                            </tr>
                        </thead>
             
                        <tbody>
                            @foreach($imputations as $imputation)
                            <tr>
                                <td>{!! $imputation->id !!}</td>
                                <td align='center'>{!! $imputation->cpt_imp !!}</td>
                                <td nowrap>{!! $imputation->designation !!}</td>
                                <td nowrap align='center'>{!! $imputation->montant !!}</td>
                                <td align='center'>{!! $imputation->type_imp !!}</td>
                                <td >{!! $imputation->obs !!}</td>
                                <td nowrap>
                                    <a href="{!! url('mandatements/imputations/'.$imputation->id) !!}" 
                                        class="box_imput fancybox.iframe btn btn-warning" 
                                        id='btn_visu_enfant' 
                                        style="margin-right: 3px;">Consulter</a>

                                @if($user->can("IMP_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                                    <a href="{!! url('imputation_edit_avec_mandat/'.$imputation->id.'/'.$mandat->id) !!}" 
                                        id='btn_maj_imputation' class="box_imput fancybox.iframe btn btn-primary" 
                                        style="margin-right: 3px;">Modifier</a>    
                                @endif 


                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class='form-group'>
            {!! Form::submit('Enregistrer les modifications', ['class' => 'btn btn-primary']) !!}
        </div>
        {!! Form::close() !!}
    </div>
</div>


@stop


@section('scripts')
    {!! Html::script('js/jquery.fancybox.js') !!}



<script type="text/javascript">
    $(document).ready(function() {
        
        $(".box_imput").fancybox({
            //maxWidth    : 800,
            //maxHeight   : 600,
            fitToView   : true,
            width       : '85%',
            height      : '70%',
            //autoSize    : true,
            //autoScale   : true,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',

        });

    });
    </script>
@stop