@extends('layouts.dash')
@section('title') ExportMandat @stop

@section('content')
    <div class="col-lg-10 col-lg-offset-1">



        <div class="card card-{!! (!isset($nom_file)?'danger':'success')!!}">
            <div class="card-header">
                @if(!isset($nom_file))
                    <h2><small class="fas fa-gear"></small>&nbsp;{!! "Génération du fichier TP pour les mandats à transférer" !!}</h2>
                {{ html()->form('POST', url('/mandats_export_fichier_TP'))->open() }}
                @else
                    <h2><small class="fas fa-upload"></small>&nbsp;{!! "Transmission fichier TP pour les mandats : ".$mandat_liste !!}</h2>
                    {{ html()->form('POST', url('/mandat_email_fichier'))->open() }}
                @endif
            </div>
            <div class='card-body'>
                <div class="row">
                    <div class="col-md-12" align='center'>
                        @if(!isset($nom_file))
                            <h4>Cette opération va permettre de générer un fichier destiné à la DFiP.</h4>
                            <h4>Ce fichier ne contiendra les paiements des mandat suivants :</h4>
                            @foreach($mandats as $mandat)
                                <h4 style="margin:1px">{!! $mandat->getListeCreancierHTML_Export() !!} </h4>
                            @endforeach
                            <h4></h4>
                        @else
                            <h4>
                                Le fichier a été généré. Il contient <b>{!! $nb_lignes !!} lignes</b>.
                                <br/>Vous pouvez le télécharger en faisant un <i>clique-droit</i> puis <i>enregistrer le lien sous</i> sur l'icône ci-dessous..
                            </h4>
                        @endif
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="" align="center">
                            @if(!isset($nom_file))
                                <div class="row form-group">
                                    <div class="col-md-2"></div>
                                    <div class="col-md-4">
                                        {!! html()->label('Compte (11 caractères)','compte') !!}
                                        {!! html()->text('compte', (isset($mandat)?$mandat->id:null))
                                            ->attributes(['placeholder'=>'Numéro de compte CPSWF', 'class' => 'form-control']) !!}
                                    </div>
                                    <div class="col-md-4">
                                        {!! html()->label('Designation','designation') !!}
                                        {!! html()->text('designation', "DFIP")
                                            ->attributes(['placeholder'=>'Numéro de compte CPSWF', 'class' => 'form-control']) !!}
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col-md-5"></div>
                                    <div class="col-md-2">
                                        {!! html()->label('Date :','date_export') !!}
                                        <div class='input-group date' id='datepicker_dateexport'>
                                            {!! html()->text('date_export', date('d/m/Y'))->attributes(['class' => 'form-control']) !!}
                                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                                            <script type="text/javascript">
                                                $(function () {
                                                    $('#datepicker_dateexport').datepicker({
                                                        format: "dd/mm/yyyy",
                                                        language: "fr",
                                                        autoclose: true
                                                    });
                                                });
                                            </script>
                                        </div>
                                    </div>
                                </div>

                                @if($nbCompteIncorrect==0)
                                    {!! html()->button('Générer le fichier des paiement du mandat DFiP')->value('Enregistrer')->type('submit')
                                        ->attributes(['class' => 'btn btn-success  form-horizontal','style'=>'padding:10px;font-size:16px']) !!}
                                @else
                                    {!! html()->button('Génération impossible<br/>certains comptes bancaires ne sont pas valides (21car. minimum)')
                                        ->attributes(['class' => 'btn btn-danger  form-horizontal','style'=>'font-size:16px']) !!}
                                @endif
                            @else
                                <input type="hidden" name="path_nom_file" id="path_nom_file" value="{!! $path_nom_file !!}">
                                <input type="hidden" name="nom_file" id="nom_file" value="{!! $nom_file !!}">
                                <div class="col-xs-12 row" style="padding-top:30px">
                                    <div class="col-md-4"></div>
                                    <div class="col-md-4">
                                        <a href="{!! url($path_nom_file) !!}" class="btn btn-success">
                                            <i class="fas fa-upload"></i>&nbsp;Télécharger
                                        </a>
                                    </div>
                                    <div class="col-md-4"></div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {{ html()->form()->close() }}
    </div>
@stop




