@extends('layouts.dash')

@section('title') Mandats @stop
@section('title_card') Mandats @stop
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">

        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-3'>
                    {!! html()->label('Années :','annes') !!}
                    {!! html()->select('exercice')->options($exercices)
                        ->value($exercice)
                        ->placeholder('Choisir un exercice')
                        ->attributes(['class' => 'form-control','id' => 'select_exercice'])  !!}
                </div>
                @if($user->can("MDT_AJO") || $user->HasRole("ADMINISTRATEUR"))
                    <div class="col-md-3 ">
                        {!! html()->label( '&nbsp;','') !!}<br/>
                        {!! html()->a(url('mandats/create'),"Ajouter un Mandat")->attributes(['class' => 'btn btn-success'])  !!}
                    </div>
                @endif
            </div>
        </div>

        <div class="card-body">
            <table id="_table" class="table table-condensed table-striped table-hover table-bordered">
                <thead>
                    <tr>
                        <th width='1px' nowrap>N°</th>
                        <th width='1px'>Exe.</th>
                        <th width='1px'>Date</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Statut<br/>Transfert</th>
                        <th width='1px'>Date de validation</th>
                        <th>Créanciers</th>
                        <th>Imputations</th>
                        <th width='1px'>Total</th>
                        <th width='1px'></th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($mandats as $mandat)
                        <?php
                            $imputation=App\Models\Imputation::find($mandat->id);
                            $class_type="";
                            if($mandat->type=='A') $class_type='bg-danger';
                        ?>
                    <tr>
                        <td align="center">
                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('mandats/'.$mandat->id)!!}"
                                    class="" style="margin-right: 3px;">
                            @endif

                            {!! str_pad($mandat->id,6,'0',STR_PAD_LEFT) !!}

                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                </a>
                            @endif
                        </td>
                        <td>{!! $mandat->exercice.$mandat->statut_transfert !!}</td>
                        <td>{!! $mandat->date_sai !!}</td>
                        <td>{!! $mandat->statut_mdt !!}</td>
                        <td>
                            {!! $mandat->StatutTransfertLibelle !!}
                            @if($mandat->statut_transfert=="TRA")
                                <br/>{!! $mandat->DateTransfert !!}
                            @endif
                        </td>
                        <td>{!! $mandat->date_valid !!}</td>
                        <td style='font-size:12px'>{!! $mandat->getListeCreancierHTML() !!}</td>
                        <td style='font-size:12px'>{!! $mandat->getListeImputationsHTML() !!}</td>
                        <td class='{!! $class_type !!}' nowrap align="right" style="color:darkblue;">{!! $mandat->montant !!}</td>
                        <td>
                        @if($user->can("MDT_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('mandats/'.$mandat->id.'/edit') !!}" class="btn btn-sm btn-info pull-left" style="margin-right: 3px;margin-bottom: 3px;">Modifier
                            </a>
                        @endif
                        @if($user->can("MDT_TRF") || $user->HasRole("ADMINISTRATEUR"))
                                @if(!$mandat->statut_transfert)
                                    <a href="{!! url('mandatements_settransfert/'.$mandat->id.'/'.$exercice) !!}" class="btn btn-sm btn-primary" >A&nbsp;Transférer
                                    </a>
                                @endif
                                @if($mandat->statut_transfert=="ATR")
                                    <a href="{!! url('mandatements_unsettransfert/'.$mandat->id.'/'.$exercice) !!}" class="btn btn-sm btn-warning" >Ne&nbsp;pas&nbsp;Transférer
                                    </a>
                                @endif
                        @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>


    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable_btn")
    <script>
        $(function () {
            $('#select_exercice').change(function() {

                var exercice=$('#select_exercice').val();
                if((exercice==undefined)||(exercice=="")) return false;;
                url="{!! url('mandats_annee/') !!}/"+exercice  ;
                location.href=url;
            });
        });
    </script>

@endsection
