@extends('layouts.dash')

@section('title') Mandats @stop
@section('title_card') Mandats @stop
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">

        @if (Session::has('message'))
            <div class="alert alert-warning">{!! Session::get('message') !!}</div>
        @endif

        <div class="card-header">
            <div class="form-group row">
                <h4>Mandats : Transferts des mandats</h4>
            </div>
        </div>

        <div class="card-body">
            <table id="_table" style="background-color:white"
                class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th width='1%' nowrap>N°</th>
                        <th width='1%'>Exe.</th>
                        <th width='1%'>Date</th>
                        <th width='1%'>Statut</th>
                        <th width='1%'>Date de validation</th>
                        <th>Créanciers</th>
                        <th>Imputations</th>
                        <th width='1%'>Total</th>
                        <!--<th width='1%'></th>-->
                    </tr>
                </thead>

                <tbody>
                    @foreach ($mandats as $mandat)
                    <tr>
                        <td align="center">{!! str_pad($mandat->id,6,'0',STR_PAD_LEFT) !!}</td>
                        <td>{!! $mandat->exercice !!}</td>
                        <td>{!! $mandat->date_sai !!}</td>
                        <td>{!! $mandat->statut_mdt !!}</td>
                        <td>{!! $mandat->date_valid !!}</td>
                        <td style='font-size:12px'>{!! $mandat->getListeCreancierHTML() !!}</td>
                        <td style='font-size:12px'>{!! $mandat->getListeImputationsHTML() !!}</td>
                        <td class='' nowrap align="right" style="color:darkblue;">{!! $mandat->montant !!}</td>
                        <!--
                        <td>
                            <div class="col-xs-3">
                                <a href="{!! url('/mandats_export_fichier_TP').'/'.$mandat->id !!}"
                                        class="btn btn-danger"  target="_blank">Générer le fichier DFiP</a>
                            </div>
                        </td>
                        -->
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="card-footer" style="">
            <a href="{!! url('/mandats_export_fichier_TP') !!}" class="btn btn-danger"  target="_blank">Générer le fichier DFiP</a>
        </div>
    </div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable_btn")
@endsection

