
<div class="form-group row">
    <div class="col-md-12" >
        <h4>Créanciers</h4>
        {!! html()->hidden('select_creancier', null)->attributes(['id' => 'select_creancier']) !!}
        <table id="_table" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>N°</th>
                    <th nowrap width='1px'>N°Imput.</th>
                    <th nowrap width='1px'>N°Bénéf.</th>
                    <th >Nom</th>
                    <th width='20%'>Banque</th>
                    <th width='1px'>Compte</th>
                    <th width='1px' >Montant</th>
                    <th width='1px'>
                    @if($mode=="edit")
                        @if($user->can("CRE_AJO") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('creancier_create_avec_mandat/'.$mandat->id) !!}"
                                id='btn_ajout_creancier'
                                class="box_creancier fancybox.iframe btn btn-sm btn-success"
                                target="_blank"><span class='fas fa-plus'></span>
                            </a>
                        @endif
                    @endif
                    </th>
                </tr>
            </thead>

            @if(isset($creanciers))
                <tbody>
                    @foreach($creanciers as $creancier)
                        <tr class="clickable-row-creancier" style="cursor: pointer;" data-href="{!! $creancier->id !!}">
                            <td align='center' style='font-style:italic;color:lightgrey' id='numimput_{!! $creancier->id !!}' >
                                <a href="{!! url('creancier_show_frame/'.$creancier->id.'/'.$mandat->id) !!}"
                                    class="box_creancier fancybox.iframe">
                                    {!! $creancier->id !!}
                                </a>
                            </td>
                            <td align='center'>{!! $creancier->idimp_mdt !!}</td>
                            <td align='center'>
                                {!! str_pad($creancier->num_creancier,'5','0',STR_PAD_LEFT) !!}
                            </td>

                            <td nowrap>{!! $creancier->nom_complet !!}</td>
                            <td nowrap align='left'>{!! ($creancier->bqcle_creancier==0)?"":$creancier->bqcle_creancier."-".$creancier->banque !!}</td>
                            <td align='center'>{!! $creancier->compte !!}</td>
                            <td align='right'>{!! $creancier->montant !!}</td>
                            <td nowrap>
                                <a href="{!! url('creancier_show_frame/'.$creancier->id.'/'.$mandat->id) !!}" class="box_imput fancybox.iframe btn btn-sm  btn-warning" id='btn_visu_imputation' style="margin-right: 3px;">
                                    <span class='fas fa-eye'></span>
                                </a>
                                @if($mode=="edit")
                                    @if($user->can("CRE_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                                        <a href="{!! url('creancier_edit_avec_mandat/'.$creancier->id.'/'.$mandat->id) !!}"
                                            id='btn_maj_creancier' class="box_creancier fancybox.iframe btn btn-sm btn-primary"
                                            style="margin-right: 3px;">
                                            <span class='fas fa-pencil'></span>
                                        </a>
                                    @endif
                                
                                    @if($user->can("IMP_SUP") || $user->HasRole("ADMINISTRATEUR"))
                                        <a href="javascript::" onclick="delete_creancier({!! $creancier->id !!});" class="btn btn-sm btn-danger" style="margin-right: 3px;">
                                            <span class='fas fa-trash'></span>
                                        </a>
                                    @endif
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            @endif
        </table>

        @if($mode=="show")
        <div class="col-lg-12">
            <div class="form-group">
                <a href="javascript:" onclick="imprime_creancier('mandat_bordereau_rglmt');return false;"
                    class="btn_creancier  btn btn-info disabled"
                    disabled target="_blank">Bordereau de règlement</a>

                <a href="javascript:" onclick="imprime_creancier('mandat_mandat_pmt_cre');return false;"
                    class="btn_creancier  btn btn-info disabled"
                    disabled target="_blank">Mandat de paiement</a>

                <a href="javascript:" onclick="imprime_annulation();return false;"
                    class="btn_imput btn_creancier  btn btn-info disabled"
                    disabled target="_blank">Mandat d'annulation</a>
            </div>
        </div>
    </div>
    @endif
</div>
