@extends('layouts.dash')
@section('title') Bénéficiaire @stop
@section('title_card')  @stop


@section('content')
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card card-info">
        <div class="card-header">
            <h2>Mandat <small>Consultation</small></h2>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($mandat)->open() }}
                @include("mandatements.mandats.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@stop

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop




@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    <script>
        $(function () {
            $(".box_imput").fancybox({
                //width:'80%',
                autoDimensions:false,
                fitToView   : false,
                autoSize    : false,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
            });
            $(".box_creancier").fancybox({
                //width:'80%',
                autoDimensions:false,
                fitToView   : false,
                autoSize    : false,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
            });
        });
    </script>

    <script>
        $(function () {
            $('#_table tbody').on( 'click', 'tr', function () {
                $(this).toggleClass('selected');
            } );

            $(".clickable-row").click(function() {
                var id=$(this).data("href");
                var old_select=$('#select_input').val();
                $('#numimput_'+old_select).removeClass('bg-danger');
                if(old_select==id) {
                    $('#select_input').val("");
                    $('.btn_imput').addClass('disabled');
                    return;
                }
                $('#numimput_'+id).addClass('bg-danger');
                $('#select_input').val(id);
                $('.btn_imput').removeClass('disabled');
            });
        });

        $( function() {
            $( "#dialog-creancier" ).dialog({
            resizable: false,
            height: "auto",
            width: 400,
            modal: true,
            autoOpen: false,
            buttons: {
                "Imprimer": function() {
                $( this ).dialog( "close" );
                //$('#nom_benef').val()=$('#nom_benef').val().replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
                url="{!! url('mandat_ordre_pmt_imp_nom'.'/'.$mandat->id) !!}";
                url+="/"+$('#nom_benef').val();
                url+="@@"+$('#lieu_benef').val();
                window.open(url,'_blank');

                },
                Annuler: function() {
                $( this ).dialog( "close" );
                }
            }
            });
        } );


        function imprime_imputation(nom) {
            var url="";
            if(nom=="mandat_mandat_pmt_imp") {
                url="{!! url('mandat_mandat_pmt_imp'.'/'.$mandat->id) !!}";
                if($('#select_input').val()!="") url+="/"+$('#select_input').val();
            }

            if(nom=="mandat_imputation") {
                if($('#select_input').val()=="") {
                    alert("Vous devez selectionner une imputation");
                    return;
                }
                url="{!! url('mandat_imputation'.'/'.$mandat->id) !!}";
                if($('#select_input').val()!="") url+="/"+$('#select_input').val();
            }
            if(nom=="mandat_ordre_pmt_imp") {
                url="{!! url('mandat_ordre_pmt_imp'.'/'.$mandat->id) !!}";
                if($('#select_input').val()!="") url+="/"+$('#select_input').val();

                if($('#select_creancier').val()!="") {
                    url+="/"+$('#select_creancier').val();
                } else {
                    $('#dialog-creancier').dialog( 'open' );return ;
                }

            }
            window.open(url,'_blank');
        }
    </script>

<script>
    jQuery(document).ready(function($) {
        $(".clickable-row-creancier").click(function() {
            var id=$(this).data("href");
            var old_select=$('#select_creancier').val();
            $('#numimput_'+old_select).removeClass('bg-danger');
            if(old_select==id) {
                $('#select_creancier').val("");
                $('.btn_creancier').addClass('disabled');
                return;
            }
            $('#numimput_'+id).addClass('bg-danger');
            $('#select_creancier').val(id);
            $('.btn_creancier').removeClass('disabled');
        });
    });

    function imprime_creancier(nom) {
        if($('#select_creancier').val()=="")  {
            alert('Il faut sélectionner un créancier');
            return;
        }
        var url="";
        if(nom=="mandat_bordereau_rglmt") url="{!! url('mandat_bordereau_rglmt') !!}"+"/"+$('#select_creancier').val();;
        if(nom=="mandat_mandat_pmt_cre") {
            url="{!! url('mandat_mandat_pmt_imp').'/'.$mandat->id !!}";
            if($('#select_input').val()=="") url+="/0"+"/"+$('#select_creancier').val();
            else url+="/"+$('#select_input').val()+"/"+$('#select_creancier').val();
        }
        window.open(url,'_blank');
    }

    function imprime_annulation() {

        var url="";
        var imput=$('#select_input').val();
        if(imput=="") imput="0";

        var creancier=$('#select_creancier').val();
        if(creancier=="") creancier=0;
        if(creancier==0) {
            alert("Vous devez selectionner un créancier");
            return;
        }

        url="{!! url('mandat_mandat_annulation').'/'.$mandat->id !!}";
        url+="/"+imput+"/"+creancier;

        window.open(url,'_blank');
    }

    </script>
@stop

