@include('forms.fbncheader')
@include('forms.fdatatables')

<div class="col-lg-10 col-lg-offset-1">

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif


    @if($message)
    <div class="bg-success alert">
        <h2>{!! $message !!}</h2>
    </div>
    @endif
    
@if (Session::has('message'))
    <div class="alert alert-info">{{ Session::get('message') }}</div>
@endif

    <h1><i class="fa fa-secteurs"></i>Importation des tables SIALE</h1>
    <div class="table-responsive">
        <table id="_table" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th width='10%'>Table origine SIALE</th>
                    <th width='50%'>Chemin</th>
                    <th width='10%'>Table destination SIPRE</th>  
                    <th width='10%'>Lignes</th>  
                    <th width='20%'></th>
                </tr>
            </thead>
 
            <tbody>
                @foreach ($table as $origine=>$dest)
                <?php
                    $path_load=$path_origine.$origine.".csv";
                ?>
                <tr>
                    <td>{!! $origine !!}</td>
                    <td>{!! $path_origine !!}</td>
                    <td>{!! $dest !!}</td>
                    <td>{!! $t_nbligne_dest[$dest] !!}</td>                   
                    <td>

                    {!! Form::open(['url' => '/param/load_table', 'method' => 'POST']) !!}

                    <input id="load_file" name="load_file" type='hidden' value='{!! $path_load."~".$dest !!}' />
                    {!! Form::submit('Importer', ['class' => 'btn btn-danger']) !!}
                    {!! Form::close() !!}
                    </td>
                </tr>
                @endforeach
            </tbody>
 
        </table>
    </div>


</div>

</body></html>
@include('forms.fdatatables_script_2')


