@extends('layouts.dash')
@section('title') Paramêtres @stop
@section('title_card',"")
@section('subtitle_card',"")


@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    
    <div class="card ">
        <div class="card-header bg-warning">
            <h4>Saisie des Paramètres - {!! $title !!}</h4>
        </div>
        @if($page)
            <div class="card-body ">
                {{ html()->modelForm($parametres, 'PUT', url('parametres_detail/'.$page))->open() }}
                    {!! html()->hidden( "page",$page) !!}
                    <div class="tab-content"> 
                            @include("param.content_".$page)
                    </div>
                    @if( ($user->can("PAR_MAJ")) || $user->HasRole("ADMINISTRATEUR")) 
                    <div class="row form-group">
                        {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary','id'=>'btn_save']) !!}
                    </div>
                    @endif
                {{ html()->form()->close() }}
            </div>
        @endif
    </div>
@endsection



@section('scripts0')

@endsection


@section('scripts')
<script>
    $(document).ready(function() {

        @if($page=="taux")
            $('#_table').dataTable( {
            	"width": "10%",
                "bAutoWidth": false,
                "bPaginate": false,
                "bInfo": false,
                "bFilter": false,
                } );
            } );


        @endif

        @if($page=="messages")
            $('.summernote').summernote();
            
            $('#btn_save').click(function() {
                @foreach ($parametres as $parametre)
                    @if(substr($parametre->ref,0,3)=='MSG')
                        var html = $('#summernote_{{ $parametre->ref }}').summernote('code');
                        $("#{{ $parametre->ref }}").val(html);
                    @endif
                @endforeach
                return true;
            });
        @endif
    })
</script>
@endsection