@extends('layouts.dash')

@section('title') Paramêtres @stop
@section('title_card',"Modification des paramêtres")

@section('content')
    <div class="card">
        <div class="card-header">
            <h4>Paramêtres</h4>
        </div>
        {{ html()->form('POST', url('/parametres'))->attributes(['parametres' => 'form', 'class' => 'form-horizontal','files' => true])->open() }}
            <div class="card-body ">
                @include("parametres/content")
                @if($user->hasRole("ADMINISTRATEUR") || $user->can("modifier parametres"))
                    <div class='form-group '>
                        {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
                    </div>
                @endif      
            </div>
        {{ html()->form()->close() }}
    </div>
@endsection


@section('scripts0')
    <script>
        $(function () {
            //color picker with addon
            $('.my-colorpicker2').colorpicker({
                 format: 'hex', 
            });

            $('.my-colorpicker2').on('colorpickerChange', function(event) {
              $('.my-colorpicker2 .fa-square').css('color', event.color.toString());
            })
        });
    </script>
@endsection