@extends('layouts.dash')

@section('title') Paramêtres @stop
@section('title_card',"Gestion des paramêtres")

@section('content')
    <div class="card">
        @if (Session::has('message'))
            <div class="alert alert-success">{!! Session::get('message') !!}</div>
        @endif
        <div class="card-header">
            <h4>Paramêtres</h4>
        </div>
        {!! Form::open(['parametres' => 'form', 'class' => 'form-horizontal', 'url' => 'parametres', 'method' => 'POST','files' => true]) !!}
        <div class="card-body ">
            @include("parametres/content")
            @if($user->hasRole("ADMINISTRATEUR") || $user->can("modifier parametres"))
                <a class="btn btn-primary"  href="{!! url('parametres_edit') !!}">Modifier</a>
            @endif      
        </div>
        {!! Form::close() !!}
    </div>
@endsection

