@extends('layouts.dash')
@section('title') Réajustements @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    <div class="card card-info">
        <div class="card-header">
            <h4>{!! "Réajustement des retraites" !!}</h4>
        </div>
        <div class="card-body">

        @if($mode=='saisie')
            @if(!isset($nom_file))
                {{ html()->form('POST', url('retraites/reajustement_simulation/'))->open() }}   
            @endif
            <div class="row">
                <div class="col-md-1"></div>
                <div class="col-md-10">
                    <div class="alert bg-warning h5">
                        <h4  align="center">
                            Cette opération va permettre de réajuster toutes les retraites en cours.
                        </h4>
                         <br/>
                         <h4 class="col-xs-10">
                             <div class="col-xs-5">Taux de réajustement (%) :</div>
                             <div class="col-xs-2" stye="margin-top:0px"> 
                                {!! html()->text( 'taux','')->attributes(['class' => 'form-control']) !!}
                            </div>
                        </h4>
                         <h4 class="col-xs-10">
                             <div class="col-xs-5">Nombre de rappels :</div>
                             <div class="col-xs-2" stye="margin-top:0px"> 
                                {!! html()->text( 'nb_rap','')->attributes(['class' => 'form-control']) !!}
                            </div>
                        </h4>
                        <br/>
                        <h4 class="col-xs-10">
                            Cliquez sur le bouton ci-dessous pour générer ce fichier.
                        </h4>
                    </div>
                </div>
            </div>

            <div class="row" >
                <div class="col-md-12" align="center">
                    {!! html()->button('Visualisation de la simulation')->value('')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
                </div> 
            </div> 
            {{ html()->form()->close() }}
        @endif    

        @if($mode=='confirm')
            {{ html()->form('POST', url('retraites/reajustement_validation/'))->open() }} 
                <input type="hidden" id="taux" name="taux" value="{!! $taux !!}">
                <input type="hidden" id="nb_rap" name="nb_rap" value="{!! $nb_rap !!}">
                <div class="row">
                    <div class='col-lg-12'>
                        <div class="">
                            <table id="_table" style="background-color:white" class="table table-striped table-bordered table-hover" width="100%" >
                                <thead>
                                    <tr>
                                        <th width='1%'>Id</th>
                                        <th>Nom</th>
                                        <th width='5%'>Date de naissance</th>
                                        <th width='10%'>Montant Ret.</th> 
                                        <th width='10%'>Montant Réajusté (+{!! $taux !!}%)</th> 
                                        <th width='10%'>Montant Rap.</th> 
                                        <th width='10%'>Montant Rap.Réajusté<br/>(+{!! $taux !!}%&nbsp;sur&nbsp;{!! $nb_rap !!}&nbsp;mois)</th> 
                                        <th width='1%'>Statut</th>
                                        <th width='1%'>TypeRet</th>
                                        <th width='1%'>DateReajust.</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($beneficiaires as $beneficiaire)
                                    <?php
                                        $areajuster=true;//($beneficiaire->ret_date_reajust=='0000-00-00 00:00:00');
                                        //Modif pour réajust dans l'année 07/2020
                                        if(substr($beneficiaire->ret_date_reajust,0,4)=="2020") $areajuster=false;
                                        $new_montant=$beneficiaire->ret_montant;
                                        $new_rappel=$beneficiaire->ret_rappel;
                                        if($areajuster) {
                                            $new_montant=round($beneficiaire->ret_montant*(1+($taux/100)),0);
                                            $new_rappel=$beneficiaire->ret_rappel+$nb_rap*(round($beneficiaire->ret_montant*($taux/100),0));
                                        }
                                        $new_montant=number_format($new_montant,0,","," ");
                                        $new_rappel=number_format($new_rappel,0,","," ");
                                    ?>
                                    <tr>
                                        <td>{!! str_pad($beneficiaire->id, 6, "0", STR_PAD_LEFT) !!}</td>
                                        <td>{!! $beneficiaire->nom_complet !!}</td>
                                        <td>{!! $beneficiaire->datenaiss !!}</td> 
                                        <td align="center">{!! $beneficiaire->ret_montant !!}</td>
                                        <td align="center" class='{!! ($areajuster)?"btn-danger":"" !!}'>{!!  $new_montant !!}</td>  
                                        <td align="center">{!! $beneficiaire->ret_rappel !!}</td>
                                        <td align="center" class='{!! ($areajuster)?"btn-danger":"" !!}'>{!! $new_rappel !!}</td>  
                                        <td align="center">{!! $beneficiaire->statut !!}</td>
                                        <td align="center">{!! $beneficiaire->ret_type !!}</td>
                                        <td align="center">{!! $beneficiaire->ret_date_reajust !!}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div> 
                <div class="row p-5" >
                    <div class="col-md-12" align="center">
                        {!! html()->button('Valider la mise à jour des retraites')->value('')->type('submit')->attributes(['class' => 'btn btn-success']) !!}
                    </div> 
                </div> 
             {{ html()->form()->close() }}
        @endif 

        @if($mode=='validation')
            <div class="row">
                <div class="col-md-12" align="center">
                    <h4>La mise à jour des retraites de {!! $nb !!} bénéficaires a été effectuée.</h4>
                </div>
            </div>
        @endif  
    </div>
</div>
@stop

@section('scripts0')
    <script>
    $(document).ready(function() {
       $.fn.dataTable.moment('D/M/YYYY');

        var table =$('#_table').dataTable( {
            bAutoWidth: false,
            bPaginate: true,
            bInfo: true,
            bFilter: true,
            deferRender:    true,
            //scrollY:        400,
            scrollCollapse: false,
            scroller:       false,

            iDisplayLength:25,
            oLanguage: {
                "sLengthMenu": 'Lignes par page <select>'+
                '<option value="25">25</option>'+
                '<option value="50">50</option>'+
                '<option value="100">100</option>'+
                '<option value="-1">Tous</option>'+
                '</select> ',
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher ",

                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                    }
                }

                },
                //"dom": '<"top"fBl>rt<"bottom"ip><"clear">',
                dom: "<'row'<'col-sm-4 text-left'fl><'col-sm-4'><'col-sm-6 text-right'>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-3'i><'col-sm-4'B><'col-sm-5'p>>",

                buttons: [ 
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} },
                    //{extend: 'pdf',exportOptions: {columns: ':visible'} },
                    //{extend: 'print',exportOptions: {columns: ':visible'} },
                    'colvis'
                ],
                
            } );
    } );
    </script>
@stop
