@extends('layouts.master')


@section('title') Nouvelle fiche versement @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    <h1><i class='fa fa-banque'></i> Nouvelle versement</h1>

    {!! Form::open(['versement' => 'form', 'url' => '/recouvrement/versements', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">

        
        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sonum', 'Employeur') !!}
                <div class="input-group">
                    @if($employeur_id!="") 
                    <div class="input-group-addon" id="ref_employeur">{!! $employeur_id !!}</div>
                    @endif
                    {!! 
                    Form::select('sonum',$liste_employeur,$employeur_id,
                        [
                            'class' => 'selectpicker show-tick',
                            'id' => 'sonum',
                            'data-width' => "100%",
                            'disabled' => ($employeur_id!="")?'true':'false',
                        ]
                        ) 
                    !!}
                </div>
            </div>
        </div>

        <div class="form-group">
                <div class="col-md-4">
                    {!! Form::label('date', 'Date d\'entrée') !!}
                    <div class="input-group">
                        <div class='input-group date' id='datepicker_date'>
                                {!! Form::text('date', '', ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_date').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="form-group">
            <div class="col-md-1">
                    {!! Form::label('exercice', 'Exercice') !!}
                    {!! Form::text('exercice', null, ['class' => 'form-control']) !!}
            </div>

            <div class="col-xs-2">
                {!! Form::label('type_cotis', 'Tyoe de versement') !!}
                {!! 
                Form::select(
                    'type_cotis',
                    [
                        'ENC'=>'Encaissement'
                        ,'RAN' => 'Report à nouveau'
                        ,'RAP' => 'Rappel'
                        ,'CAT' => 'Cession activité temporaire'
                        ,'CAD' => 'Cession activité définitive'
                        ,'PEC' => 'Paiement echelonné'
                        ],
                    $versement->type_cotis,
                    [
                        'class' => 'selectpicker'
                        ,'data-width' => "100%"
                    ]
                ) 
                    
                !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-2">
                    {!! Form::label('nbmois', 'Nombre de mois') !!}
                    {!! Form::text('nbmois', null, ['placeholder' => 'Nombre de mois','class' => 'form-control']) !!}
            </div>

            <div class="col-md-4">
                {!! Form::label('mois', 'Mois de départ') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_mois'>
                            {!! Form::text('mois', '', ['placeholder' => 'Mois de départ', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_mois').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-2">
                    {!! Form::label('bdx', 'Numéro de bordereau') !!}
                    {!! Form::text('bdx', null, ['placeholder' => 'Numéro de bordereau','class' => 'form-control']) !!}
            </div>
            <div class="col-md-2">
                    {!! Form::label('nbsal', 'Nombre de salariés') !!}
                    {!! Form::text('nbsal', null, ['placeholder' => 'Nombre de salariés','class' => 'form-control']) !!}
            </div>
            <div class="col-md-2">
                    {!! Form::label('bdx_prive', 'Numéro de bordereau privé') !!}
                    {!! Form::text('bdx_prive', null, ['placeholder' => 'Numéro de bordereau privé','class' => 'form-control']) !!}
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-2">
                    {!! Form::label('compte', 'Compte') !!}
                    {!! Form::text('compte', null, ['placeholder' => 'Compte','class' => 'form-control']) !!}
            </div>
            <div class="col-md-2">
                    {!! Form::label('typepmt', 'Type de paiement') !!}
                    {!! 
                    Form::select(
                        'typepmt',
                        [
                            'A'=>'Autre'
                            ,'B' => 'Banque'
                            ,'E' => 'Espèce'
                            ,'T' => 'Trésor'
                            ,'V' => 'Virement'
                            ,'€' => 'Euro'
                            ,'N' => 'Nul'
                            ],
                        $versement->type_cotis,
                        [
                            'class' => 'selectpicker'
                            ,'data-width' => "100%"
                        ]
                    ) 
                        
                    !!}
           </div>
        </div>


        <div class='form-group'>
            <div class="col-md-8">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>



</div>

    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary']) !!}
    </div>
 
    {!! Form::close() !!}
 
</div>

@stop