@include('forms.fbncheader')
@include('forms.fdatatables')

<div class="col-lg-max">
    <h1><i class="fa fa-employeurs"></i>{!! $titre_versement !!}</h1>

    <div class='form-group form-horizontal' style="">
        <div class="col-lg-max form-horizontal">
            <div class="col-xs-1" style="padding-top:10px">
                {!! Form::label('sonum', 'Mois :') !!}
            </div>
            <div class="col-xs-3">
                {!! Form::select('annee_mois_id',
                    $liste_annees_mois,
                    $annee_mois_id,
                    [
                        'id' => 'annee_mois_id2','class' => 'form-control selectpicker show-tick',
                        'data-width' => "90%",'style' => 'font-weight:bold;'
                    ]
                ) 
                !!}
                <script>
                    $(document).ready(function() {
                        $('#annee_mois_id2').on('change', function() {
                            location.href="{!! url('/versements_encours/'.$type) !!}/"
                                +$('#annee_mois_id2').val();
                        });
                    });
                </script>
            </div>
            <div class="col-xs-3">
                @if($type!="")
                    <a href="{!! url('versements_print/'.$type.'/'.$annee_mois_id) !!}" 
                                class="btn btn-info"  target="_blank">Imprimer le borderau</a>
                @endif
            </div>
        </div>
    </div>



<br/><br/>

@if($type!="")


        <div class="table-responsive">
            <table id="_table" class="table table-condensed table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th>Bénéficiaire</th>
                        <th width='1%'>Naissance</th>
                        <th width='1%'>Type</th>
                        <th width='1%'>Ret.</th>
                        <th width='1%' nowrap>N°IMP</th> 
                        <th width='1%'>Rappel</th>
                        <th width='1%'>Montant</th>
                        <th width='10%'>Banque</th>
                        <th width='10%'>Compte</th>
                        <th width='200px'>&nbsp</th>
                    </tr>
                </thead>
     
                <tbody>
                @foreach ($versements as $versement)
                
                <tr>
                    <td style="color:grey">{!! $versement->id !!}</td>
                    <td>{!! $versement->nom_beneficiaire." ".$versement->prenom_beneficiaire !!}</td>
                    <td>{!! $versement->naissance_beneficiaire !!}</td>
                    <td align="center">{!! $versement->type !!}</td>
                    <td align="center">{!! $versement->ret_type !!}</td>
                    <td align="center">{!! $versement->num_imp !!}</td>
                    <td align="right" nowrap>{!! number_format($versement->montant_r,0,","," ")!!}</td>
                    <td align="right" nowrap>{!! number_format($versement->montant_c,0,","," ") !!}</td>
                    <td>{!! $versement->banque_nom !!}</td>
                    <td>{!! $versement->compte !!}</td>
                    <!-- <td align="center">{!! $versement->nb_enfants !!}</td> -->
                    <td nowrap>
                        @if($user->can("VER_VISU") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('prestations/versements/'.$versement->id ) !!}"
                                 class="btn btn-warning pull-left" style="margin-right: 3px;">Consulter</a>
                        @endif 
                        @if($user->can("VER_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('prestations/versements/'.$versement->id .'/edit') !!}"
                                 class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                        @endif 
                        @if($user->can("VER_SUP") || $user->HasRole("ADMINISTRATEUR"))   
                            {!! Form::open(['url' => 'recouvrement/versements/' . $versement->id, 'method' => 'DELETE']) !!}
                            {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                            {!! Form::close() !!}
                        @endif
                    </td>
                </tr>
                    @endforeach
                </tbody>
     
            </table>
        </div>

<!--
        @if($user->can("VER_AJO") || $user->HasRole("ADMINISTRATEUR"))
             <div>
                <h4><a href="{!! url('prestations/versements/create/'.$type) !!}" 
                    class="btn btn-success">Ajouter un Versement</a></h4>
            </div> 
        @endif
-->

@endif
</div>

</body></html>


<script>
$(document).ready(function() {
    $('#_table').dataTable( {
        "bAutoWidth": false,
        "bPaginate": false,
        "bInfo": true,
        "bFilter": true,
        "oLanguage": {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
             "sSearch":"Chercher",
            },

        "order": [[ 1, "desc" ]]

        } );
 } );
</script>
