
@extends('layouts.dash')
@section('title') Versements @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    <div class="card card-success">
        <div class="card-header">
            <h4>{!! "Exportation des versements DFiP" !!}</h4>
        </div>
        <div class="card-body">
            @if(!isset($nom_file))
                {{ html()->form('POST', url('versements_export_fichier_TP/'.$type.'/'.$num_imp))->open() }}   
            @endif
            <div class="row">
                <div class="col-md-1"></div>
                <div class="col-md-10" align="center">
                    <h4>{!! ((!isset($nom_file))?"Génération ":"Transmission")." du fichier DFiP pour les ".$user->getTitreStatut($type) !!}</h4>  
                </div>
            </div>
             <div class="row">
                <div class="col-md-1"></div>
                <div class="col-md-10">
                    <div class="alert bg-info h5">
                        <h4  align="center">
                            @if(!isset($nom_file))
                                Cette opération va permettre de générer un fichier destiné à la DFiP.
                                <br/>Ce fichier ne contiendra les opérations de versement de l'imprimé N° {!! $num_imp !!} pour les bénéficiaires <b>{!! $user->getTitreStatut($type,true) !!} </b>.
                                <br/><br/>Cliquez sur le bouton ci-dessous pour générer ce fichier.
                            @else
                               Le fichier a été généré. Il contient <b>{!! $nb_lignes !!} lignes</b>.
                                <br/>Vous pouvez le télécharger en faisant un <i>clique-droit</i> puis <i>enregistrer le lien sous</i> sur l'icône ci-dessous..
                            @endif
                        </h4>
                    </div>
                </div>
            </div>
            <div class="form-group">
                @if(!isset($nom_file))
                    <div class="row" >
                        <div class="col-md-2"></div>
                        <div class="col-md-3">
                            {!! html()->label('Compte (11 caractères)','compte') !!}
                            {!! html()->text('compte', null)->attributes(['class' => 'form-control']) !!}
                        </div>
                        <div class="col-md-3">
                            {!! html()->label("Designation",'designation') !!}
                            {!! html()->text('designation', null)->attributes(['class' => 'form-control']) !!}
                        </div>
                        <div class="col-md-2">
                            {!! html()->label("Date :",'date_export') !!}
                            <div class='input-group date' id='datepicker_date_export'>
                                {!! html()->text( 'date_export',date('d/m/Y'))->attributes(['class' => 'form-control']) !!}
                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            </div>
                        </div>
                    </div>
                    </br>
                    <div class="row" >
                        <div class="col-md-12" align="center">
                            {!! html()->button('Générer le fichier des versements DFiP')->value('')->type('submit')->attributes(['class' => 'btn btn-success']) !!}
                        </div>
                    </div>
                @else
                    <input type="hidden" name="path_nom_file" value="{!! $path_nom_file !!}">
                    <input type="hidden" name="nom_file" value="{!! $nom_file !!}">
                    <div class="row">
                        <div class="col-md-12" align="center">
                            <a href="{!! url($path_nom_file) !!}" class="btn btn-primary">Télécharger</a>
                        </div>
                    </div>
                @endif
                </div>
                @if(!isset($nom_file))
                    {{ html()->form()->close() }}
                @endif
            </div>
        </div>
    </div>
@stop

@section('scripts0')
    <script type="text/javascript">
        $(function () {
            $('#datepicker_date_export').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });
        });
    </script>
@stop



