@extends('layouts.dash')
@section('title') Versements @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header bg-warning">
            {!! "Versement définitifs des ".$user->getTitreStatut($type) !!}
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-2 mb-2">
                {!! html()->label("Numéro d'imprimé&nbsp;:&nbsp;",'brd') !!}
                {!! html()->select('num_imp')->options($liste_num_imp)
                    ->value($num_imp)
                    ->placeholder('A définir')
                    ->attributes(['id' => 'num_imp','class' => 'form-control ','data-width' => "90%",'style' => 'font-weight:bold;'])  !!}
                </div>
            </div>
            @if($type!="")
                <div class="row">
                    <div class="table-responsive">
                        <table id="_table" class="table table-condensed table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width='1%'>N°</th>
                                    <th width='1%'>N°Emp</th>
                                    <th >Bénéficiaire</th>
                                    <th width='1%'>NbEnf{!! ($type!="RET")?" Considérés":"" !!}</th>
                                    <th width='1%'>Naissance</th>
                                    <th width='1%'>Statut</th>
                                    <th width='1%'>Type</th>
                                    @if($type=="RET")
                                    <th width='1%'>RetType</th>
                                    <th width='1%'>RetDate</th>
                                    <th width='1%'>RetNum</th>
                                    @endif
                                    <!-- <th width='1%' nowrap>N°IMP</th> -->
                                    <th width='1%'>Rappel</th>
                                    <th width='1%'>Calcul</th>
                                    <th width='1%'>Montant</th>
                                    <th width='10%'>Banque</th>
                                    <th width='10%'>Compte</th>
                                    <th>Obs</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($versements as $versement)
                                    <?php
                                        $beneficiaire=App\Models\Beneficiaire::find($versement->benum);
                                        $beneftype=substr($type,0,1);
                                    ?>
                                    <tr>
                                        <td style="color:grey">{!! $versement->benum !!}</td>
                                        <td style="color:grey">{!! $versement->sonum !!}</td>
                                        <td>
                                            <a href="{!! url('beneficiaires_filtre/'.$beneficiaire->id.'/'.$beneftype) !!}" target="_blank">
                                            {!! $versement->nom_beneficiaire." ".$versement->prenom_beneficiaire !!}
                                            </a>
                                        </td>
                                        <td>
                                            {!! $versement->nb_enf.(($type=="RET")?"":"/".$beneficiaire->NbEnfants) !!}
                                        </td>
                                        <td>{!! $versement->naissance_beneficiaire !!}</td>
                                        <td align="center">{!! $versement->statut_beneficiaire !!}</td>
                                        <td align="center">{!! $versement->type !!}</td>
                                        @if($type=="RET")
                                        <td align="center">{!! $versement->ret_type !!}</td>
                                        <td align="center">{!! $versement->ret_date !!}</td>
                                        <td align="center">{!! $versement->ret_num !!}</td>
                                        @endif
                                        <!-- <td align="center">{!! $versement->num_imp !!}</td> -->
                                        <td align="right" nowrap>{!! number_format($versement->montant_r,0,","," ")!!}</td>
                                        <td align="right" nowrap>{!! number_format($versement->montant_c,0,","," ") !!}</td>
                                        <td align="right" style="font-weight:bold;" class="bg-danger" nowrap>{!! number_format($versement->montant,0,","," ") !!}</td>
                                        <td>{!! $versement->banque_nom !!}</td>
                                        <td>{!! $versement->compte !!}</td>
                                        <td>{!! $versement->obs_vers !!}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @endif
        </div>
        @if($type!="")
            <div class="card-footer">
                 <div class="row">
                    <div class="col-md-2" >
                        <a href="{!! url('versements_print/'.$type.'/'.$num_imp) !!}" class="btn btn-primary"  target="_blank">Imprimer&nbsp;le&nbsp;borderau</a>
                    </div>
                    @if($user->can("RET_VER_EXP") || $user->can("ALL_VER_EXP") || $user->can("SOC_VER_EXP") || $user->HasRole("ADMINISTRATEUR"))
                        <div class="col-md-2">
                            <a href="{!! url('versements_export_fichier_complet/'.$type.'/'.$num_imp) !!}" class="btn btn-warning"  target="_blank">Générer le fichier DFiP</a>
                        </div>
                    @endif
                </div>
            </div>
        @endif
    </div>
@endsection

@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>
    @include('forms.scripts_datatable_btn')
    <script>
        $("._box").fancybox({
            //fitToView   : true,
            width       : '85%',
            height      : '85%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#num_imp').on('change', function() {
                location.href="{!! url('/versements/'.$type) !!}/"+$('#num_imp').val();
            });
        });
    </script>
@endsection


