@extends('layouts.dash_pop')


@section('content')
    <div class="card card-info">
        <div class="card-header">
            <h3 class="card-title">{!! $titre_versement !!}</h3>
        </div>
        <div align="center" class="card-body">
            <div class="col-lg-12">
                @if(count($enfants)==0)
                    <div class="bg-danger alert">
                        Aucun enfant n'est actuellement concerné par cette opération.
                    </div>
                @else
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>Id</th>
                                <th>Nom</th>
                                <th width='1%'>Sexe</th>
                                <th width='1%'>Date de naissance</th>
                                <th width='1%'>Age</th>
                                <th width='1%'>Certificat</th>
                                <th width='1%'>Nouveau Certificat</th>
                                <th width='10%'>Responsable</th>
                                <th width='1%'>Statut Resp.</th>
                                <th width='10%'>Conjoint</th>
                                <th width='1%'>Statut Conj.</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($enfants as $enfant)
                                <?php $class=($enfant->NewCertificat==$enfant->certif)?'success':'danger'; ?>
                                <tr>
                                    <td>{!! str_pad($enfant->id, 6, "0", STR_PAD_LEFT) !!}</td>
                                    <td>{!! $enfant->NomCompletReduit  !!}</td>
                                    <td nowrap>{!! $enfant->sexe !!}</td>
                                    <td nowrap align="center">{!! $enfant->datenais !!}</td>
                                    <td nowrap align="center">{!! $enfant->age !!}</td>
                                    <td nowrap align="center">{!! $enfant->certif !!}</td>
                                    <td nowrap align="center" class="bg-{!! $class !!}">{!! $enfant->NewCertificat !!}</td>
                                    <td>{!! $enfant->nom_parent1_reduit !!}</td>
                                    <td nowrap align="center">{!! $enfant->statut_parent1  !!}</td>
                                    <td>{!! $enfant->nom_parent2_reduit !!}</td>
                                    <td nowrap align="center">{!! $enfant->statut_parent2  !!}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            </div>
        </div>
    </div>
@stop









