@extends('layouts.dash')
@section('title') Génération @stop
@section('title_card',"")
@section('subtitle_card',"")

@section('content')
    <div class="card card-info">
        <div class="card-header">
            <h3 class="card-title">{!! $titre_versement !!}</h3>
        </div>
        <div align="center" class="card-body">
            @if($nb_modif=="")
                {{ html()->form('POST', url('maj_certificats'.(($etrangers)?"_etrangers":"").'/'.$type))->open() }}
                    <div class="h5 col-md-12 alert">
                        <h4  style="text-align:left;">
                            <div>Cette opération va permettre de :</div>
                            <ul>
                                @if(!$etrangers)
                                    <li>Mettre à 0 les certificats des enfants de + de 6 ans</li>
                                    <li>Mettre à 9 les certificats des enfants de + de 21 ans</li>
                                    <li>Mettre à 1 les certificats des enfants de - de 6 ans</li>
                                @else
                                    <li>Mettre à 0 les certificats des enfants scolarisés à l'étarnger (<b>France,Tahiti</b>)</li>

                                @endif
                            </ul>
                            <br/>Cette opération de ne s'appliquera que pour les <b>{!! $libelle_beneficiaire !!} </b>.
                            <br/><br/>Cliquez sur le bouton ci-dessous pour valider l'opération.
                        </h4>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group" align="center">
                                <a href="{!! url('maj_certificats_info/'.$type.(($etrangers)?'/1':'')) !!}"  id='btn_infos' style="font-size:24px"
                                class="box_info fancybox.iframe btn btn-info" target="_blank">Vérification avant changement</a>

                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group" align="center">
                            {!! html()->button('Mise à jour des certificats')->type('submit')->attributes(['class' => 'btn btn-danger','style'=>'font-size:24px']) !!}
                        </div>
                    </div>
                {{ html()->form()->close() }}
            @else
                <div class="row" align="center">
                    <div class="col-md-12">
                        <h4>
                            Opération de remise à zéro tous les montants de rappel dans les fiche bénéficiaires est terminée.
                            <br/>Cette opération de ne s'est appliquée que pour les {!! $libelle_beneficiaire !!}  
                            <br/><br/><b>{!! $nb_modif !!} fiches </b>bénéficiaires ont été concernées par cette opération.
                        </h4>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection


@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $(".box_info").fancybox({
                fitToView   : false,
                autoSize    : false,
                autoScale   : false,
                width       : '85%',
                height      : '70%',
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
            });
        });
    </script>
@endsection




